% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lords_amendments.R
\name{lords_amendments}
\alias{lords_amendments}
\alias{hansard_lords_amendments}
\title{House of Lords Amendments.}
\usage{
lords_amendments(decision = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")

hansard_lords_amendments(decision = NULL, start_date = "1900-01-01",
  end_date = Sys.Date(), extra_args = NULL, tidy = TRUE,
  tidy_style = "snake_case")
}
\arguments{
\item{decision}{The decision on the amendments. Accepts one of 'Withdrawn', 'Agreed', 'Disagreed', 'Pending', 'NotMoved', 'Disposed'. Defaults to NULL.}

\item{start_date}{The earliest date to include in the tibble. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{end_date}{The latest date to include in the tibble. Defaults to current system date. Defaults to '1900-01-01'. Accepts character values in 'YYYY-MM-DD' format, and objects of class Date, POSIXt, POSIXct, POSIXlt or anything else than can be coerced to a date with \code{as.Date()}.}

\item{extra_args}{Additional parameters to pass to API. Defaults to NULL.}

\item{tidy}{Fix the variable names in the tibble to remove special characters and superfluous text, and converts the variable names to a consistent style. Defaults to TRUE.}

\item{tidy_style}{The style to convert variable names to, if tidy = TRUE. Accepts one of 'snake_case', 'camelCase' and 'period.case'. Defaults to 'snake_case'.}
}
\value{
A tibble with details on amendments proposed by the House of Lords.
}
\description{
Returns a tibble with all available House of Lords amendments.
}
\examples{
\dontrun{

x <- lords_amendments()

x <- lords_amendments(decision='Withdrawn')

}
}
\keyword{Amendments}
\keyword{House}
\keyword{Lords}
\keyword{of}
