% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_CAMELS.R
\name{read_CAMELS}
\alias{read_CAMELS}
\title{Reads simulated and observed values from CAMELS netcdf file for a single location}
\usage{
read_CAMELS(nc_file, site, obsName = "obs", simName = "kge")
}
\arguments{
\item{nc_file}{Required. netCDF file to read CAMELS data from.}

\item{site}{Required. Site number to extract data.}

\item{obsName}{Required. Name for variable containing observations. Default is "obs".}

\item{simName}{Required. Name for variable containing simulations. Default is "kge".}
}
\value{
Returns a data frame containing the date, observed and simulated flows. The name of the
observed flow variable is \code{obs}, the name of the simulated flow variable is \code{sim}.
}
\description{
Reads simulated and observed values from CAMELS netcdf file for a single location
}
\examples{
\dontrun{
flows <- read_CAMELS(nc_file = "CAMELS_flow.nc", site = 1030500)
}
}
\seealso{
\code{\link{CAMELS_bootjack}}
}
\author{
Martyn Clark and Kevin Shook
}
