% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/transfers.R
\name{gtfs_transfer_table}
\alias{gtfs_transfer_table}
\title{gtfs_transfer_table}
\usage{
gtfs_transfer_table(
  gtfs,
  d_limit = 200,
  min_transfer_time = 120,
  network = NULL,
  network_times = FALSE,
  quiet = FALSE
)
}
\arguments{
\item{gtfs}{A GTFS feed obtained from the \link{extract_gtfs} function.}

\item{d_limit}{Upper straight-line distance limit in metres for transfers.}

\item{min_transfer_time}{Minimum time in seconds for transfers; all values
below this will be replaced with this value, particularly all those defining
in-place transfers where stop longitudes and latitudes remain identical.}

\item{network}{Optional Open Street Map representation of the street network
encompassed by the GTFS feed (see Examples).}

\item{network_times}{If \code{TRUE}, transfer times are calculated by routing
throughout the underlying street network. If this is not provided as the
\code{net} parameter, it will be automatically downloaded. If a network, is
provided, this parameter is automatically set to \code{TRUE}.}

\item{quiet}{Set to \code{TRUE} to suppress screen messages}
}
\value{
Modified version of the \code{gtfs} input with additional transfers table.
}
\description{
Construct a transfer table for a GTFS feed.
}
\examples{
# Examples must be run on single thread only:
nthr <- data.table::setDTthreads (1)

berlin_gtfs_to_zip ()
f <- file.path (tempdir (), "vbb.zip")
g <- extract_gtfs (f, quiet = TRUE)
g <- gtfs_transfer_table (g, d_limit = 200)
# g$transfers then has fewer rows than original, because original transfer
# table contains duplicated rows.

data.table::setDTthreads (nthr)
}
\seealso{
Other augment: 
\code{\link{frequencies_to_stop_times}()}
}
\concept{augment}
