% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gtfs_subset.R
\name{[.gtfs}
\alias{[.gtfs}
\title{Subset a GTFS object}
\usage{
\method{[}{gtfs}(x, value)
}
\arguments{
\item{x}{A GTFS object.}

\item{value}{Either a numeric or a character vector. Designates the elements
to be returned.}
}
\value{
A GTFS object.
}
\description{
Subsetting a GTFS object using \code{[} preserves the object class.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")

gtfs <- import_gtfs(gtfs_path)
names(gtfs)
class(gtfs)

small_gtfs <- gtfs[1:5]
names(small_gtfs)
class(small_gtfs)

small_gtfs <- gtfs[c("shapes", "trips")]
names(small_gtfs)
class(small_gtfs)

}
