% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checks.R
\name{check_file_exists}
\alias{check_file_exists}
\alias{assert_file_exists}
\title{Check the existence of text files in a GTFS object}
\usage{
check_file_exists(x, files)

assert_file_exists(x, files)
}
\arguments{
\item{x}{A GTFS object.}

\item{files}{A character vector. The files to check the existence of.}
}
\value{
\code{check_file_exists} returns \code{TRUE} if the check is successful, and
\code{FALSE} otherwise. \cr
\code{assert_file_exists} returns \code{x} invisibly if the check is
successful, and throws an error otherwise.
}
\description{
Checks the existence of elements inside a GTFS object that represent specific
GTFS text files.
}
\examples{
gtfs_path <- system.file("extdata/ggl_gtfs.zip", package = "gtfsio")
gtfs <- import_gtfs(gtfs_path)

check_file_exists(gtfs, c("calendar", "agency"))

check_file_exists(gtfs, c("calendar", "oi"))

}
\seealso{
Other checking functions: 
\code{\link{check_field_class}()},
\code{\link{check_field_exists}()}
}
\concept{checking functions}
