% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gt_highlight_cols.R
\name{gt_highlight_cols}
\alias{gt_highlight_cols}
\title{Add color highlighting to a specific column(s)}
\usage{
gt_highlight_cols(
  gt_object,
  columns,
  fill = "#80bcd8",
  alpha = 1,
  font_weight = "normal"
)
}
\arguments{
\item{gt_object}{An existing gt table object of class \code{gt_tbl}}

\item{columns}{Specific columns to apply color to, accepts either \code{tidyeval} colum names or columns by position.}

\item{fill}{A character string indicating the fill color. If nothing is provided, then "#80bcd8" (light blue) will be used as a default.}

\item{alpha}{An optional alpha transparency value for the color as single value in the range of 0 (fully transparent) to 1 (fully opaque). If not provided the fill color will either be fully opaque or use alpha information from the color value if it is supplied in the #RRGGBBAA format.}

\item{font_weight}{A string or number indicating the weight of the font. Can be a text-based keyword such as "normal", "bold", "lighter", "bolder", or, a numeric value between 1 and 1000, inclusive. Note that only variable fonts may support the numeric mapping of weight.}
}
\value{
An object of class \code{gt_tbl}.
}
\description{
The \code{gt_highlight_cols} function takes an existing \code{gt_tbl} object and
adds highlighting color to the cell background of a specific column(s).
}
\section{Examples}{


\if{html}{\out{<div class="sourceCode r">}}\preformatted{library(gt)
basic_col <- head(mtcars) \%>\%
  gt() \%>\%
  gt_highlight_cols(cyl, fill = "red", alpha = 0.5)
}\if{html}{\out{</div>}}
}

\section{Figures}{

\if{html}{\figure{highlight-col.png}{options: width=70\%}}
}

\section{Function ID}{

2-9
}

\seealso{
Other Utilities: 
\code{\link{add_text_img}()},
\code{\link{fa_icon_repeat}()},
\code{\link{fmt_pad_num}()},
\code{\link{fmt_pct_extra}()},
\code{\link{fmt_symbol_first}()},
\code{\link{generate_df}()},
\code{\link{gt_add_divider}()},
\code{\link{gt_badge}()},
\code{\link{gt_double_table}()},
\code{\link{gt_duplicate_column}()},
\code{\link{gt_fa_column}()},
\code{\link{gt_fa_rank_change}()},
\code{\link{gt_fa_rating}()},
\code{\link{gt_fa_repeats}()},
\code{\link{gt_highlight_rows}()},
\code{\link{gt_img_circle}()},
\code{\link{gt_img_multi_rows}()},
\code{\link{gt_img_rows}()},
\code{\link{gt_index}()},
\code{\link{gt_merge_stack}()},
\code{\link{gt_two_column_layout}()},
\code{\link{gtsave_extra}()},
\code{\link{img_header}()},
\code{\link{pad_fn}()},
\code{\link{tab_style_by_grp}()}
}
\concept{Utilities}
