% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcsbm.R
\docType{class}
\name{dcsbm-class}
\alias{dcsbm-class}
\title{Degree Corrected Stochastic Block Model class}
\description{
An S4 class to represent a degree corrected stochastic block model, extend \code{\link{icl_model-class}}.
Such model can be used to cluster graph vertex, and model a square adjacency matrix \eqn{X} with the following generative model :  
\deqn{ \pi \sim Dirichlet(\alpha)}
\deqn{ Z_i  \sim \mathcal{M}(1,\pi)}
\deqn{ \theta_{kl} \sim Exponential(p)}
\deqn{ \gamma_i^+,\gamma_i^- \sim \mathcal{U}(S_k)}
\deqn{ X_{ij}|Z_{ik}Z_{jl}=1 \sim \mathcal{P}(\gamma_i^+\theta_{kl}\gamma_j^-)}
The individuals parameters \eqn{\gamma_i^+,\gamma_i^-} allow to take into account the node degree heterogeneity. 
These parameters have uniform priors over the simplex \eqn{S_k} ie. \eqn{\sum_{i:z_{ik}=1}\gamma_i^+=1}. This class mainly store the prior parameters value \eqn{\alpha} of this generative model in the following slots (the prior parameter \eqn{p} is estimated from the data as the global average probability of connection between two nodes):
}
\section{Slots}{

\describe{
\item{\code{name}}{name of the model}

\item{\code{alpha}}{Dirichlet over cluster proportions prior parameter (default to 10)}

\item{\code{p}}{Exponential prior parameter (default to NaN, in this case p will be estimated from data as the mean connection probability)}

\item{\code{type}}{define the type of networks (either "directed" or "undirected", default to "directed")}
}}

