% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resample.R
\name{resample}
\alias{resample}
\title{Re-sample model estimates}
\usage{
resample(object, k = 5, bootstrap = FALSE, seed = NULL, ...)
}
\arguments{
\item{object}{a PlackettLuce model object}

\item{k}{an integer for the number of bins to subset the data}

\item{bootstrap}{logical, to run a Bayesian bootstrapping on object}

\item{seed}{integer, the seed for random number generation. If NULL (the default),
gosset will set the seed randomly}

\item{...}{additional arguments passed to methods, see details}
}
\value{
A data frame with re-sampled estimates
}
\description{
Applies a k-fold approach to re-sample 
estimates from PlackettLuce model. The function will 
subset the data into 'k' number folds and re-calculate
the model estimates. Optionally, a Bayesian bootstrapping 
technique can be used to increase output size and normalize 
the distribution of estimates
}
\details{
Additional details for Bayesian bootstrapping: 
\code{statistic} A function that accepts data as its first argument and possibly, 
the weights as its second, if use_weights is TRUE; \code{n1} The size of 
the bootstrap sample; \code{n2} The sample size used to calculate 
the statistic each bootstrap draw
}
\examples{
library("PlackettLuce")

data("breadwheat", package = "gosset")

G = rank_tricot(breadwheat,
                items = c("variety_a","variety_b","variety_c"),
                input = c("overall_best","overall_worst"),
                group = FALSE)

mod = PlackettLuce(G)

# default method, no bootstrapping and 5 folds
resample(mod)

resample(mod, log = FALSE)

# the argument 'seed' will make sure that the function 
# always return the same results
resample(mod, log = FALSE, seed = 1526)

# add bootstrapping
resample(mod, bootstrap = TRUE, log = FALSE, n1 = 100)

}
\author{
Kauê de Sousa
}
