% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/auth.R
\name{gce_auth}
\alias{gce_auth}
\title{Authenticate this session}
\usage{
gce_auth(new_user = FALSE, no_auto = FALSE)
}
\arguments{
\item{new_user}{If TRUE, reauthenticate via Google login screen}

\item{no_auto}{Will ignore auto-authentication settings if TRUE

If you have set the environment variable \code{GCE_AUTH_FILE} to a valid file location,
  the function will look there for authentication details.
Otherwise it will look in the working directory for the `.httr-oauth` file, which if not present
  will trigger an authentication flow via Google login screen in your browser.

If \code{GCE_AUTH_FILE} is specified, then \code{gce_auth()} will be called upon loading the package
  via \code{library(googleComputeEngineR)},
  meaning that calling this function yourself at the start of the session won't be necessary.

\code{GCE_AUTH_FILE} can be either a token generated by \link[googleAuthR]{gar_auth} or
  service account JSON ending with file extension \code{.json}}
}
\value{
Invisibly, the token that has been saved to the session
}
\description{
A wrapper for \link[googleAuthR]{gar_auth} and \link[googleAuthR]{gar_auth_service}
}
