% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mask.R
\name{unmask}
\alias{unmask}
\alias{unmask.data.frame}
\alias{unmask.DataFrameStack}
\alias{unmask.SpatialPixels}
\alias{unmask.SpatialPoints}
\title{Unmask a masked object}
\usage{
unmask(x, ...)

\method{unmask}{data.frame}(
  x,
  mask = attr(x, "mask"),
  fullgrid = attr(mask, "fullgrid"),
  forceCheck = is(fullgrid, "GridTopology"),
  ...
)

\method{unmask}{DataFrameStack}(
  x,
  mask = attr(x, "mask"),
  fullgrid = attr(mask, "fullgrid"),
  forceCheck = is(fullgrid, "GridTopology"),
  ...
)

\method{unmask}{SpatialPixels}(
  x,
  mask = NULL,
  fullgrid = attr(mask, "fullgrid"),
  forceCheck = FALSE,
  ...
)

\method{unmask}{SpatialPoints}(
  x,
  mask = attr(x@data, "mask"),
  fullgrid = attr(mask, "fullgrid"),
  forceCheck = FALSE,
  ...
)
}
\arguments{
\item{x}{a masked object}

\item{...}{arguments for generic functionality}

\item{mask}{the mask; typically has good defaults}

\item{fullgrid}{the full grid; typically has good defaults}

\item{forceCheck}{if \code{fullgrid} is provided, should the coordinates provided
in \code{x} and in \code{fullgrid} be cross-checked to ensure that they are given in
compatible orders? See \code{\link[=sortDataInGrid]{sortDataInGrid()}} and \code{\link[=setGridOrder]{setGridOrder()}} for controlling
the ordering of vectors and grids.}
}
\value{
The original grid data and extend potential
data containers associated to it with NAs. See examples in \code{\link[=constructMask]{constructMask()}}.
The nature of the output depends on the nature of \code{x}:
a "data.frame" produced a "data.frame";
a "unmask.DataFrameStack" produces a "unmask.DataFrameStack";
a "SpatialPoints" produces a "SpatialPoints"; and finally
a "SpatialPixels" produces either a "SpatialPixels" or a "SpatialGrid" (if it is full).
Note that only in the case that \code{class(x)=="SpatialPixels"} is \code{mask} required,
for the other methods all arguments have reasonable defaults.
}
\description{
Unmask a masked object, i.e. recover the original grid and extend potential
data containers associated to it with NAs. See examples in \code{\link[=constructMask]{constructMask()}}
}
\section{Functions}{
\itemize{
\item \code{unmask}: Unmask a masked object

\item \code{unmask.DataFrameStack}: Unmask a masked object

\item \code{unmask.SpatialPixels}: Unmask a masked object

\item \code{unmask.SpatialPoints}: Unmask a masked object
}}

\seealso{
Other masking functions: 
\code{\link{constructMask}()},
\code{\link{getMask}()},
\code{\link{print.mask}()},
\code{\link{setMask}()}
}
\concept{masking functions}
