% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glmmGene.R
\name{glmmGene}
\alias{glmmGene}
\title{Glmm for sequencing results of a single gene}
\usage{
glmmGene(
  modelFormula,
  countdata,
  gene,
  metadata,
  id,
  dispersion,
  sizeFactors = NULL,
  reducedFormula = "",
  modelData = NULL,
  control = glmerControl(optimizer = "bobyqa"),
  zeroCount = 0.125,
  removeDuplicatedMeasures = FALSE,
  removeSingles = FALSE,
  verbose = FALSE,
  ...
)
}
\arguments{
\item{modelFormula}{the model formula. For more information of formula
structure see \code{\link[lme4:glmer]{lme4::glmer()}}.}

\item{countdata}{the sequencing data}

\item{gene}{the row name in countdata to be used}

\item{metadata}{a data frame of sample information}

\item{id}{Column name in metadata which contains the sample IDs to be used
in pairing}

\item{dispersion}{a numeric for the gene dispersion}

\item{sizeFactors}{size factors (default=NULL). If provided the glmer offset
is set to log(sizeFactors).For more information see
\code{\link[lme4:glmer]{lme4::glmer()}}}

\item{reducedFormula}{Reduced design formula (default="")}

\item{modelData}{something something}

\item{control}{the glmer control
(default=glmerControl(optimizer="bobyqa")).
For more information see
\code{\link[lme4:glmerControl]{lme4::glmerControl()}}.}

\item{zeroCount}{numerical value to offset zeroes for the purpose of log
(default=0.125)}

\item{removeDuplicatedMeasures}{whether to remove duplicated
conditions/repeated measurements for a given time point (default=FALSE).}

\item{removeSingles}{whether to remove individuals with only one measurement
(default=FALSE)}

\item{verbose}{Logical whether to display messaging (default=FALSE)}

\item{...}{Other parameters to pass to
\code{\link[lme4:glmer]{lme4::glmer()}}.}
}
\value{
Returns the fit for the general linear mixed model of a single gene
}
\description{
Glmm for sequencing results of a single gene
}
\examples{
data(PEAC_minimal_load)
disp <- apply(tpm, 1, function(x) {
(var(x, na.rm=TRUE)-mean(x, na.rm=TRUE))/(mean(x, na.rm=TRUE)**2)
})
MS4A1fit <- glmmGene(~ Timepoint * EULAR_6m + (1 | PATID),
                      gene = "MS4A1",
                      id = "PATID",
                      countdata = tpm,
                      metadata = metadata,
                      dispersion = disp["MS4A1"],
                      verbose=FALSE)

MS4A1fit
}
