% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_get_lau.R
\name{gisco_get_lau}
\alias{gisco_get_lau}
\alias{gisco_get_communes}
\title{Get GISCO urban areas \code{sf} polygons, points and lines}
\usage{
gisco_get_communes(
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  spatialtype = "RG",
  country = NULL
)

gisco_get_lau(
  year = "2016",
  epsg = "4326",
  cache = TRUE,
  update_cache = FALSE,
  cache_dir = NULL,
  verbose = FALSE,
  country = NULL,
  gisco_id = NULL
)
}
\arguments{
\item{year}{Release year of the file. See Details.}

\item{epsg}{projection of the map: 4-digit \href{https://epsg.io/}{EPSG code}.
One of:
\itemize{
\item "4258": ETRS89
\item "4326": WGS84
\item "3035": ETRS89 / ETRS-LAEA
\item "3857": Pseudo-Mercator
}}

\item{cache}{A logical whether to do caching. Default is \code{TRUE}. See
\strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
.geojson file.}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{spatialtype}{Type of geometry to be returned:
\itemize{
\item \strong{"BN"}: Boundaries - \code{LINESTRING} object.
\item \strong{"COASTL"}: coastlines - \code{LINESTRING} object.
\item \strong{"INLAND"}: inland boundaries - \code{LINESTRING} object.
\item \strong{"LB"}: Labels - \code{POINT} object.
\item \strong{"RG"}: Regions - \code{MULTIPOLYGON/POLYGON} object.
}}

\item{country}{Optional. A character vector of country codes. It could be
either a vector of country names, a vector of ISO3 country codes or a
vector of Eurostat country codes. Mixed types (as \code{c("Turkey","US","FRA")})
would not work. See also \code{\link[countrycode:countrycode]{countrycode::countrycode()}}.}

\item{gisco_id}{Optional. A character vector of GISCO_ID LAU values.}
}
\value{
A \code{sf} object specified by \code{spatialtype}. In the case of
\code{\link[=gisco_get_lau]{gisco_get_lau()}}, a \code{POLYGON} object.
}
\description{
\code{\link[=gisco_get_communes]{gisco_get_communes()}} and \code{\link[=gisco_get_lau]{gisco_get_lau()}} download shapes of Local
Urban Areas, that correspond roughly with towns and cities.
}
\details{
Valid years for eacg function are:
\itemize{
\item \strong{\code{gisco_get_communes}}: one of '2001', '2004', '2006', '2008', '2010',
'2013' or '2016'.
\item \strong{\code{gisco_get_lau}}: one of
'2011', '2012', '2013', '2014', '2015', '2016', '2017', '2018', '2019', '2020'.
}
}
\note{
Please check the download and usage provisions on \code{\link[=gisco_attributions]{gisco_attributions()}}.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\examples{
\dontshow{if (gisco_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{

ire_lau <- gisco_get_communes(spatialtype = "LB", country = "Ireland")

if (!is.null(ire_lau)) {
  library(ggplot2)

  ggplot(ire_lau) +
    geom_sf(shape = 21, col = "#009A44", size = 0.5) +
    labs(
      title = "Communes in Ireland",
      subtitle = "Year 2016",
      caption = gisco_attributions()
    ) +
    theme_void() +
    theme(text = element_text(
      colour = "#009A44",
      family = "serif", face = "bold"
    ))
}
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other political: 
\code{\link{gisco_bulk_download}()},
\code{\link{gisco_get_coastallines}()},
\code{\link{gisco_get_countries}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_postalcodes}()},
\code{\link{gisco_get_units}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{political}
