% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gisco_bulk_download.R
\name{gisco_bulk_download}
\alias{gisco_bulk_download}
\title{Bulk download from GISCO API}
\source{
\url{https://gisco-services.ec.europa.eu/distribution/v2/}
}
\usage{
gisco_bulk_download(
  id_giscoR = c("countries", "coastallines", "communes", "lau", "nuts", "urban_audit"),
  year = "2016",
  cache_dir = NULL,
  update_cache = FALSE,
  verbose = FALSE,
  resolution = "10",
  ext = c("geojson", "shp", "svg", "json", "gdb"),
  recursive = TRUE
)
}
\arguments{
\item{id_giscoR}{Type of dataset to be downloaded. Values supported are:
\itemize{
\item "coastallines"
\item "communes"
\item "countries"
\item "lau"
\item "nuts"
\item "urban_audit"
}}

\item{year}{Release year of the file. See Details}

\item{cache_dir}{A path to a cache directory. See \strong{About caching}.}

\item{update_cache}{A logical whether to update cache. Default is \code{FALSE}.
When set to \code{TRUE} it would force a fresh download of the source
.geojson file.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{resolution}{Resolution of the geospatial data. One of
\itemize{
\item "60": 1:60million
\item "20": 1:20million
\item "10": 1:10million
\item "03": 1:3million
\item "01": 1:1million
}}

\item{ext}{Extension of the file(s) to be downloaded. Formats available are
"geojson", "shp", "svg", "json", "gdb". See \strong{Details}.}

\item{recursive}{Tries to unzip recursively the zip files (if any) included
in the initial bulk download (case of \code{ext = "shp"}).}
}
\value{
Silent function.
}
\description{
Downloads zipped data from GISCO and extract them on the \code{cache_dir} folder.
}
\details{
See the years available in the corresponding functions:
\itemize{
\item \code{\link[=gisco_get_coastallines]{gisco_get_coastallines()}}
\item \code{\link[=gisco_get_communes]{gisco_get_communes()}}
\item \code{\link[=gisco_get_countries]{gisco_get_countries()}}
\item \code{\link[=gisco_get_lau]{gisco_get_lau()}}
\item \code{\link[=gisco_get_nuts]{gisco_get_nuts()}}
\item \code{\link[=gisco_get_urban_audit]{gisco_get_urban_audit()}}
}

The usual extension used across \strong{giscoR} is "geojson",
however other formats are already available on GISCO.
}
\section{About caching}{
You can set your \code{cache_dir} with \code{\link[=gisco_set_cache_dir]{gisco_set_cache_dir()}}.

Sometimes cached files may be corrupt. On that case, try re-downloading
the data setting \code{update_cache = TRUE}.

If you experience any problem on download, try to download the
corresponding .geojson file by any other method and save it on your
\code{cache_dir}. Use the option \code{verbose = TRUE} for debugging the API query.

For a complete list of files available check \link{gisco_db}.
}

\examples{
\dontshow{if (gisco_check_access()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\dontrun{

# Countries 2016 - It would take some time
gisco_bulk_download(id_giscoR = "countries", resolution = "60")
}
\dontshow{\}) # examplesIf}
}
\seealso{
Other political: 
\code{\link{gisco_get_coastallines}()},
\code{\link{gisco_get_countries}()},
\code{\link{gisco_get_lau}()},
\code{\link{gisco_get_nuts}()},
\code{\link{gisco_get_postalcodes}()},
\code{\link{gisco_get_units}()},
\code{\link{gisco_get_urban_audit}()}
}
\concept{political}
