% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/linked_brush.R
\name{linked_brush}
\alias{linked_brush}
\title{Create a linked brush object.}
\usage{
linked_brush(keys, fill = "red")
}
\arguments{
\item{keys}{vector of all possible keys, if known.}

\item{fill}{brush colour}
}
\value{
A list with components:
  \item{input}{A function that takes a visualisation as an argument and
     adds an input brush to that plot}
  \item{selected}{A reactive providing a logical vector that describes
    which points are under the brush}
  \item{fill}{A reactive that gives the fill colour of points under the
    brush}
}
\description{
A linked brush has two sides: input and output
}
\note{
\code{linked_brush} is very new and is likely to change substantially
  in the future
}
\examples{
lb <- linked_brush(keys = 1:nrow(mtcars), "red")

# Change the colour of the points
mtcars \%>\%
 ggvis(~disp, ~mpg) \%>\%
 layer_points(fill := lb$fill, size.brush := 400) \%>\%
 lb$input()

# Display one layer with all points and another layer with selected points
library(shiny)
mtcars \%>\%
 ggvis(~disp, ~mpg) \%>\%
 layer_points(size.brush := 400) \%>\%
 lb$input() \%>\%
 layer_points(fill := "red", data = reactive(mtcars[lb$selected(), ]))
}

