% Generated by roxygen2 (4.0.1): do not edit by hand
\name{auto_group}
\alias{auto_group}
\title{Automatically group data by grouping variables}
\usage{
auto_group(vis, exclude = NULL)
}
\arguments{
\item{vis}{The ggvis visualisation to modify.}

\item{exclude}{A vector containing names of props to exclude from auto grouping.
It is often useful to exclude \code{c("x", "y")}, when one of those variables
is categorical.}
}
\description{
Use \code{auto_group} to group up a dataset on all categorical variables
specified by props, and have each piece rendered by the same mark.
}
\examples{
# Make cyl a factor (as it really should be)
mtcars2 <- mtcars
mtcars2$cyl <- factor(mtcars2$cyl)

# One line
mtcars2 \%>\% ggvis(~disp,  ~mpg, stroke = ~cyl) \%>\% layer_paths()
# One line for each level of cyl
mtcars2 \%>\% ggvis(~disp,  ~mpg, stroke = ~cyl) \%>\% group_by(cyl) \%>\%
  layer_paths()
mtcars2 \%>\% ggvis(~disp,  ~mpg, stroke = ~cyl) \%>\% auto_group() \%>\%
  layer_paths()
}
\seealso{
To manually specify grouping variables, see \code{\link{group_by}}.
}

