% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-tile-rast.R
\name{geom_tile_rast}
\alias{geom_tile_rast}
\title{This geom is similar to \code{\link[ggplot2]{geom_tile}}, but creates a raster layer}
\usage{
geom_tile_rast(
  ...,
  raster.dpi = getOption("ggrastr.default.dpi", 300),
  dev = "cairo"
)
}
\arguments{
\item{...}{Other arguments passed on to \code{\link[ggplot2:layer]{layer()}}. These are
often aesthetics, used to set an aesthetic to a fixed value, like
\code{colour = "red"} or \code{size = 3}. They may also be parameters
to the paired geom/stat.}

\item{raster.dpi}{An integer of length one setting the desired resolution in dots per inch. (default=300)}

\item{dev}{A character specifying a device. Can be one of: \code{"cairo"}, \code{"ragg"} or \code{"ragg_png"}. (default="cairo")}
}
\value{
geom_tile plot with rasterized layer
}
\description{
This geom is similar to \code{\link[ggplot2]{geom_tile}}, but creates a raster layer
}
\section{Aesthetics}{


\code{geom_tile()} understands the following aesthetics (required aesthetics are in bold):
\itemize{
\item \strong{\code{x}}
\item \strong{\code{y}}
\item \code{alpha}
\item \code{colour}
\item \code{fill}
\item \code{group}
\item \code{height}
\item \code{linetype}
\item \code{size}
\item \code{width}
}
Learn more about setting these aesthetics in \code{vignette("ggplot2-specs")}.

}

\examples{
library(ggplot2)
library(ggrastr)

coords <- expand.grid(1:100, 1:100)
coords$Value <- 1 / apply(as.matrix(coords), 1, function(x) sum((x - c(50, 50))^2)^0.01)
ggplot(coords) + geom_tile_rast(aes(x=Var1, y=Var2, fill=Value))

}
