% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ggcontinuousexpdist.R
\name{ggcontinuousexpdist}
\alias{ggcontinuousexpdist}
\title{Create a continuous exposure fit plot}
\usage{
ggcontinuousexpdist(
  data = effICGI,
  response = "response",
  endpoint = "Endpoint",
  DOSE = "DOSE",
  color_fill = "DOSE",
  exposure_metrics = c("AUC", "CMAX"),
  exposure_metric_split = c("median", "tertile", "quartile", "none"),
  exposure_metric_soc_value = -99,
  exposure_metric_plac_value = 0,
  exposure_distribution = c("distributions", "lineranges", "none"),
  dose_plac_value = "Placebo",
  xlab = "Exposure Values",
  ylab = "Probability of Response",
  mean_text_size = 5,
  mean_obs_bydose = TRUE,
  N_text_size = 5,
  binlimits_text_size = 5,
  binlimits_ypos = -Inf,
  binlimits_color = "gray70",
  dist_position_scaler = 0.2,
  dist_offset = 0,
  lineranges_ypos = -1,
  lineranges_dodge = 1,
  yproj = TRUE,
  yproj_xpos = 0,
  yproj_dodge = 0.2,
  yaxis_position = c("left", "right"),
  facet_formula = NULL,
  theme_certara = TRUE
)
}
\arguments{
\item{data}{Data to use with multiple endpoints stacked into Endpoint(endpoint name), response 0/1}

\item{response}{name of the column holding the valuesresponse 0/1}

\item{endpoint}{name of the column holding the name/key of the endpoint default to \code{Endpoint}}

\item{DOSE}{name of the column holding the DOSE values default to \code{DOSE}}

\item{color_fill}{name of the column to be used for color/fill default to DOSE column}

\item{exposure_metrics}{name(s) of the column(s) to be stacked into \code{expname} \code{exptile} and split into \code{exposure_metric_split}}

\item{exposure_metric_split}{one of "median", "tertile", "quartile", "none"}

\item{exposure_metric_soc_value}{special exposure code for standard of care default -99}

\item{exposure_metric_plac_value}{special exposure code for placebo default 0}

\item{exposure_distribution}{one of distributions, lineranges or none}

\item{dose_plac_value}{string identifying placebo in DOSE column}

\item{xlab}{text to be used as x axis label}

\item{ylab}{text to be used as y axis label}

\item{mean_text_size}{mean text size default to 5}

\item{mean_obs_bydose}{observed mean by dose TRUE/FALSE}

\item{N_text_size}{N respondents/Ntotal by exposure bin text size default to 5}

\item{binlimits_text_size}{5 binlimits text size}

\item{binlimits_ypos}{binlimits y position default to 0}

\item{binlimits_color}{binlimits text color default to "gray70"}

\item{dist_position_scaler}{space occupied by the distribution default to 0.2}

\item{dist_offset}{offset where the distribution position starts 0}

\item{lineranges_ypos}{where to put the lineranges -1}

\item{lineranges_dodge}{lineranges vertical dodge value 1}

\item{yproj}{project the probabilities on y axis \code{TRUE}/\code{FALSE}}

\item{yproj_xpos}{y projection x position 0}

\item{yproj_dodge}{y projection dodge value 0.2}

\item{yaxis_position}{where to put y axis "left" or "right"}

\item{facet_formula}{facet formula to be use otherwise \code{endpoint ~ expname}}

\item{theme_certara}{apply certara colors and format for strips and default colour/fill}
}
\description{
Produces a logistic fit plot with a facettable exposures/quantiles/distributions in ggplot2
}
\examples{
# Example 1
library(ggplot2)
library(patchwork)
effICGI <- logistic_data |>
dplyr::filter(!is.na(ICGI7))|>
dplyr::filter(!is.na(AUC))
effICGI$DOSE <- factor(effICGI$DOSE,
                      levels=c("0", "600", "1200","1800","2400"),
                      labels=c("Placebo", "600 mg", "1200 mg","1800 mg","2400 mg"))
effICGI$STUDY <- factor(effICGI$STUDY)    
effICGI <- tidyr::gather(effICGI,Endpoint,response,ICGI7,BRLS)
a <- ggcontinuousexpdist(data = effICGI |> dplyr::filter(Endpoint =="ICGI7"),
                 response = "response",
                 endpoint = "Endpoint",
                 exposure_metrics = c("AUC"),
                 exposure_metric_split = c("quartile"),
                 exposure_metric_soc_value = -99,
                 exposure_metric_plac_value = 0,
                 dist_position_scaler = 1, dist_offset = -1 ,
                 yproj_xpos =  -20 ,
                 yproj_dodge = 20 ,
                 exposure_distribution ="distributions")

b <- ggcontinuousexpdist(data = effICGI |> dplyr::filter(Endpoint =="BRLS"),
                 response = "response",
                 endpoint = "Endpoint",
                 exposure_metrics = c("AUC"),
                 exposure_metric_split = c("quartile"),
                 exposure_metric_soc_value = -99,
                 exposure_metric_plac_value = 0,
                 dist_position_scaler = 4.2, dist_offset = 5 ,
                 yproj_xpos =  -20 ,
                 yproj_dodge = 20 ,
                 exposure_distribution ="distributions")            
a / b +
plot_layout(guides = "collect") &
 theme(legend.position = "top")

#Example 2
effICGI$SEX <- as.factor(effICGI$SEX)
ggcontinuousexpdist(data = effICGI |>
  dplyr::filter(Endpoint =="ICGI7"),
                 response = "response",
                 endpoint = "Endpoint",
                 color_fill = "SEX",
                 exposure_metrics = c("AUC"),
                 exposure_metric_split = c("quartile"),
                 exposure_metric_soc_value = -99,
                 exposure_metric_plac_value = 0,
                 dist_position_scaler = 1, dist_offset = -1 ,
                 yproj_xpos =  -20 ,
                 yproj_dodge = 20 ,
                 exposure_distribution ="lineranges")
\dontrun{
#Example 5
}
}
