% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geom-linked-text.r
\name{geom_linked_text}
\alias{geom_linked_text}
\title{Linked Text}
\usage{
geom_linked_text(
  mapping = NULL,
  data = NULL,
  stat = "identity",
  position = "identity",
  ...,
  parse = FALSE,
  nudge_x = 0,
  nudge_y = 0,
  arrow = NULL,
  check_overlap = FALSE,
  na.rm = FALSE,
  show.legend = NA,
  inherit.aes = TRUE
)
}
\arguments{
\item{mapping}{Set of aesthetic mappings created by
\code{\link[ggplot2]{aes}} or \code{\link[ggplot2]{aes_}}. If specified and
\code{inherit.aes = TRUE} (the default), is combined with the default
mapping at the top level of the plot. You only need to supply
\code{mapping} if there isn't a mapping defined for the plot.}

\item{data}{A data frame. If specified, overrides the default data frame
defined at the top level of the plot.}

\item{stat}{The statistical transformation to use on the data for this layer,
as a string.}

\item{position}{Position adjustment, either as a string, or the result of a
call to a position adjustment function.}

\item{...}{other arguments passed on to \code{\link[ggplot2]{layer}}. There
  are three types of arguments you can use here:

  \itemize{ \item Aesthetics: to set an aesthetic to a fixed value, like
  \code{colour = "red"} or \code{size = 3}. \item Other arguments to the
  layer, for example you override the default \code{stat} associated with the
  layer. \item Other arguments passed on to the stat. }}

\item{parse}{If \code{TRUE}, the labels will be parsed into expressions and
displayed as described in \code{?plotmath}.}

\item{nudge_x, nudge_y}{Horizontal and vertical adjustments to nudge the
starting position of each text label. The units for \code{nudge_x} and
\code{nudge_y} are the same as for the data units on the x-axis and y-axis.}

\item{arrow}{specification for arrow heads, as created by
\code{\link[grid]{arrow}}}

\item{check_overlap}{If \code{TRUE}, text that overlaps previous text in the
same layer will not be plotted. \code{check_overlap} takes place at draw
time and in the order of the data, thus its action depends of the size at
which the plot is drawn.}

\item{na.rm}{If \code{FALSE} (the default), removes missing values with a
warning.  If \code{TRUE} silently removes missing values.}

\item{show.legend}{logical. Should this layer be included in the legends?
\code{NA}, the default, includes if any aesthetics are mapped. \code{FALSE}
never includes, and \code{TRUE} always includes.}

\item{inherit.aes}{If \code{FALSE}, overrides the default aesthetics, rather
than combining with them. This is most useful for helper functions that
define both data and aesthetics and shouldn't inherit behaviour from the
default plot specification, e.g. \code{\link[ggplot2]{borders}}.}
}
\description{
Text geoms are useful for labelling plots. `geom_linked_text()`
  adds text to the plot and for nudged positions links the original location
  to the nudged text with a segment.
}
\details{
Note that when you resize a plot, text labels stay the same size,
  even though the size of the plot area changes. This happens because the
  "width" and "height" of a text element are 0. Obviously, text labels do
  have height and width, but they are physical units, not data units. For the
  same reason, stacking and dodging text will not work by default, and axis
  limits are not automatically expanded to include all text.

  By default this geom uses `position_nudge_center()` which is backwards
  compatible with `position_nudge()` from 'ggplot2' but provides additional
  control on the direction of the nudging. In contrast to `position_nudge()`,
  `position_nudge_center()` and `position_nudge_line()` preserve the original
  coordinates.
}
\section{Under development}{

  This is a very simple and preliminary version of a geom. I plan to add
  features like padding around text and points. I aim to make use of the new
  features of 'grid' in R >= 4.1.0 to keep the implementation as fast and
  simple as possible. Currently this geom does all drawing using at most two
  vectorized calls to 'grid' functions. As a temporary replacement of padding
  around text one can use 'slightly out-of-range' numeric values for
  justification as shown in the examples.
}

\section{Alignment}{
 You can modify text alignment with the `vjust` and
  `hjust` aesthetics. These can either be a number between 0 (right/bottom)
  and 1 (top/left) or a character (`"left"`, `"middle"`, `"right"`,
  `"bottom"`, `"center"`, `"top"`). There are two special alignments:
  `"inward"` and `"outward"`. Inward always aligns text towards the center,
  and outward aligns it away from the center.
}

\examples{

my.cars <- mtcars[c(TRUE, FALSE, FALSE, FALSE), ]
my.cars$name <- rownames(my.cars)
p <- ggplot(my.cars, aes(wt, mpg, label = name))

# default behavior is as for geon_text()
p + geom_linked_text()
# Avoid overlaps
p + geom_linked_text(check_overlap = TRUE)
# Change size of the label
p + geom_linked_text(size = 2.5)

# Use nudging
p +
  geom_point() +
  geom_linked_text(hjust = -0.04, nudge_x = 0.12) +
  expand_limits(x = 6.2)
p +
  geom_point() +
  geom_linked_text(hjust = -0.04, nudge_x = 0.12,
  arrow = arrow(length = grid::unit(1.5, "mm"))) +
  expand_limits(x = 6.2)
p +
  geom_point() +
  geom_linked_text(vjust = -0.5, nudge_y = 0.5)
p +
  geom_point() +
  geom_linked_text(hjust = -0.02, nudge_x = 0.1,
                   vjust = -0.2, nudge_y = 0.5)
p +
  geom_point() +
  geom_linked_text(angle = 90,
                   hjust = -0.04, nudge_y = 1,
                   arrow = arrow(length = grid::unit(1.5, "mm"))) +
  expand_limits(y = 40)

# Add aesthetic mappings
p +
  geom_point() +
  geom_linked_text(aes(colour = factor(cyl)),
                   angle = 90,
                   hjust = -0.04, nudge_y = 1,
                   arrow = arrow(length = grid::unit(1.5, "mm"))) +
  scale_colour_discrete(l = 40) +
  expand_limits(y = 40)

p + geom_linked_text(aes(size = wt)) +
    expand_limits(x = c(2, 6))
# Scale height of text, rather than sqrt(height)
p +
  geom_linked_text(aes(size = wt)) +
  scale_radius(range = c(3,6)) +
    expand_limits(x = c(2, 6))

# You can display expressions by setting parse = TRUE.  The
# details of the display are described in ?plotmath, but note that
# geom_linked_text uses strings, not expressions.
p +
  geom_linked_text(
    aes(label = paste(wt, "^(", cyl, ")", sep = "")),
    parse = TRUE
  )

# Add a text annotation
p +
  geom_linked_text() +
  annotate(
    "linked_text", label = "plot mpg vs. wt",
    x = 2, y = 15, size = 3, colour = "red"
  )  +
 expand_limits(x = c(1.5, 6))

# Justification -------------------------------------------------------------
df <- data.frame(
  x = c(1, 1, 2, 2, 1.5),
  y = c(1, 2, 1, 2, 1.5),
  text = c("bottom-left", "bottom-right", "top-left", "top-right", "center")
)
ggplot(df, aes(x, y)) +
  geom_linked_text(aes(label = text))
ggplot(df, aes(x, y)) +
  geom_linked_text(aes(label = text), vjust = "inward", hjust = "inward")

}
