% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_pred.R
\name{plot_pred}
\alias{plot_pred}
\title{Plot the predictor matrix of an imputation model}
\usage{
plot_pred(
  data,
  vrb = "all",
  method = NULL,
  label = TRUE,
  square = TRUE,
  rotate = FALSE
)
}
\arguments{
\item{data}{A predictor matrix for \code{mice}, typically generated with \link[mice:make.predictorMatrix]{mice::make.predictorMatrix} or \link[mice:quickpred]{mice::quickpred}.}

\item{vrb}{String, vector, or unquoted expression with variable name(s), default is "all".}

\item{method}{Character string or vector with imputation methods.}

\item{label}{Logical indicating whether predictor matrix values should be displayed.}

\item{square}{Logical indicating whether the plot tiles should be squares.}

\item{rotate}{Logical indicating whether the variable name labels should be rotated 90 degrees.}
}
\value{
An object of class \code{ggplot2::ggplot}.
}
\description{
Plot the predictor matrix of an imputation model
}
\examples{
pred <- mice::quickpred(mice::nhanes)
plot_pred(pred)
}
