% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{plot_pred}
\alias{plot_pred}
\title{Plot the predictor matrix of an imputation model}
\usage{
plot_pred(data, label = FALSE, square = TRUE, rotate = FALSE)
}
\arguments{
\item{data}{A predictor matrix for \code{mice}, typically generated with \code{mice::make.predictorMatrix()} or \code{mice::quickpred()}. #TODO link!}

\item{label}{Logical indicating whether predictor matrix values should be displayed.}

\item{square}{Logical indicating whether the plot tiles should be squares.}

\item{rotate}{Logical indicating whether the variable name labels should be rotated 90 degrees.}
}
\value{
An object of class \code{ggplot2::ggplot}.
}
\description{
Plot the predictor matrix of an imputation model
}
\examples{
pred <- mice::make.predictorMatrix(mice::nhanes)
plot_pred(pred, label = TRUE)
}
