% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.R
\name{set_girafe_defaults}
\alias{set_girafe_defaults}
\title{Modify defaults girafe animation options}
\usage{
set_girafe_defaults(
  fonts = NULL,
  opts_sizing = NULL,
  opts_tooltip = NULL,
  opts_hover = NULL,
  opts_hover_key = NULL,
  opts_hover_inv = NULL,
  opts_hover_theme = NULL,
  opts_selection = NULL,
  opts_selection_inv = NULL,
  opts_selection_key = NULL,
  opts_selection_theme = NULL,
  opts_zoom = NULL,
  opts_toolbar = NULL
)
}
\arguments{
\item{fonts}{default values for \code{fonts}, see argument \code{fonts}
of \code{\link[=dsvg]{dsvg()}} function.}

\item{opts_sizing}{default values for \code{\link[=opts_sizing]{opts_sizing()}} used
in argument \code{options} of \code{girafe()} function.}

\item{opts_tooltip}{default values for \code{\link[=opts_tooltip]{opts_tooltip()}} used
in argument \code{options} of \code{girafe()} function.}

\item{opts_hover}{default values for \code{\link[=opts_hover]{opts_hover()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_hover_key}{default values for \code{\link[=opts_hover_key]{opts_hover_key()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_hover_inv}{default values for \code{\link[=opts_hover_inv]{opts_hover_inv()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_hover_theme}{default values for \code{\link[=opts_hover_theme]{opts_hover_theme()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_selection}{default values for \code{\link[=opts_selection]{opts_selection()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_selection_inv}{default values for \code{\link[=opts_selection_inv]{opts_selection_inv()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_selection_key}{default values for \code{\link[=opts_selection_key]{opts_selection_key()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_selection_theme}{default values for \code{\link[=opts_selection_theme]{opts_selection_theme()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_zoom}{default values for \code{\link[=opts_zoom]{opts_zoom()}} used in argument \code{options} of \code{girafe()} function.}

\item{opts_toolbar}{default values for \code{\link[=opts_toolbar]{opts_toolbar()}} used in argument \code{options} of \code{girafe()} function.}
}
\description{
girafe animation options (see \code{\link[=girafe_defaults]{girafe_defaults()}})
are automatically applied to every girafe you produce.
Use \code{set_girafe_defaults()} to override them. Use \code{init_girafe_defaults()}
to re-init all values with the package defaults.
}
\examples{
library(ggplot2)

set_girafe_defaults(
  opts_hover = opts_hover(css = "r:10px;"),
  opts_hover_inv = opts_hover_inv(),
  opts_sizing = opts_sizing(rescale = FALSE, width = .8),
  opts_tooltip = opts_tooltip(opacity = .7,
                              offx = 20, offy = -10,
                              use_fill = TRUE, use_stroke = TRUE,
                              delay_mouseout = 1000),
  opts_toolbar = opts_toolbar(position = "top", saveaspng = FALSE),
  opts_zoom = opts_zoom(min = .8, max = 7)
)

init_girafe_defaults()
}
\seealso{
Other girafe animation options: 
\code{\link{girafe_defaults}()},
\code{\link{girafe_options}()},
\code{\link{init_girafe_defaults}()},
\code{\link{opts_hover}()},
\code{\link{opts_selection}()},
\code{\link{opts_sizing}()},
\code{\link{opts_toolbar}()},
\code{\link{opts_tooltip}()},
\code{\link{opts_zoom}()}
}
\concept{girafe animation options}
