% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pred.R
\name{pred_fun_Y}
\alias{pred_fun_Y}
\title{Fit Outcome Model}
\usage{
pred_fun_Y(
  model,
  yrestrictions,
  outcome_type,
  outcome_name,
  time_name,
  obs_data,
  model_fits
)
}
\arguments{
\item{model}{Model statement for the outcome variable.}

\item{yrestrictions}{List of vectors. Each vector containins as its first entry
a condition and its second entry an integer. When the
condition is \code{TRUE}, the outcome variable is simulated
according to the fitted model; when the condition is \code{FALSE},
the outcome variable takes on the value in the second entry.}

\item{outcome_type}{Character string specifying the "type" of the outcome. The possible "types" are: \code{"survival"}, \code{"continuous_eof"}, and \code{"binary_eof"}.}

\item{outcome_name}{Character string specifying the name of the outcome variable in \code{obs_data}.}

\item{time_name}{Character string specifying the name of the time variable in \code{obs_data}.}

\item{obs_data}{Data on which the model is fit.}

\item{model_fits}{Logical scalar indicating whether to return the fitted models. The default is \code{FALSE}.}
}
\value{
Fitted model for the outcome variable.
}
\description{
This internal function fits a generalized linear model (GLM) for the outcome variable using the observed data.
}
\keyword{internal}
