% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_tb_burden_summary.R
\name{plot_tb_burden_summary}
\alias{plot_tb_burden_summary}
\title{Plot Summaries of TB Burden - By Region, Globally and for Custom Groups}
\usage{
plot_tb_burden_summary(df = NULL, dict = NULL, metric = "e_inc_num",
  metric_label = NULL, conf = c("_lo", "_hi"), years = NULL,
  samples = 1000, countries = NULL, compare_to_region = FALSE,
  compare_to_world = TRUE, custom_compare = NULL,
  compare_all_regions = TRUE, stat = "rate", denom = "e_pop_num",
  rate_scale = 1e+05, truncate_at_zero = TRUE, annual_change = FALSE,
  smooth = FALSE, facet = NULL, legend = "top", trans = "identity",
  scales = "fixed", interactive = FALSE, viridis_palette = "viridis",
  viridis_direction = -1, viridis_end = 0.9, download_data = TRUE,
  save = TRUE, verbose = TRUE, ...)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{dict}{A tibble of the data dictionary. See \code{\link[getTBinR]{get_data_dict}}
for details. If not supplied the function will attempt to load a saved version of the
dictionary. If this fails and \code{download_data = TRUE} then the dictionary will be downloaded.}

\item{metric}{Character string specifying the metric to plot}

\item{metric_label}{Character string defaulting to \code{NULL}. If supplied this metric will be looked up
using the WHO data dictionary to provide a label. A use case would be when calculating incidence rates using \code{e_inc_100k}
to get the WHO TB incidence rate label.}

\item{conf}{Character vector specifying the name variations to use to specify the upper
and lower confidence intervals. Defaults to c("_lo", "_hi"), if set to \code{NULL}
then no confidence intervals are shown. When \code{annual_change = TRUE} the confidence
intervals represent the annual percentage change in the metrics confidence intervals.}

\item{years}{Numeric vector of years. Defaults to \code{NULL} which includes all years in the data.}

\item{samples}{Numeric, the number of samples to use to generate confidence
intervals (only used when \code{conf} are present)}

\item{countries}{A character string specifying the countries to target.}

\item{compare_to_region}{Logical, defaults to \code{FALSE}. If \code{TRUE} all
countries that share a region with those listed in \code{countries} will be plotted.
Note that this will override settings for \code{facet}, unless it is set to "country".}

\item{compare_to_world}{Logical, defaults to \code{TRUE}. Should a comparison be made to
the metric of interests global value.}

\item{custom_compare}{Logical, defaults to \code{NULL}. A named list of custom countries.}

\item{compare_all_regions}{Logical, defaults to \code{TRUE}. Should all regions be compared.}

\item{stat}{Character string, defaults to \code{"rate"}. The statistic to use to summarise the metric, currently
\code{"mean"}, \code{"median"}, \code{"rate"} and \code{"prop"} are supported. Note "mean" and "median" do not recompute the supplied
country levels values but can be used to summarise the distribution of region or global metrics. \code{"prop"} and\code{"rate"}
compute the overall incidence rate for a given grouping (i.e the sum of the metric divided by the sum of the denominator).}

\item{denom}{Character string defaulting to \code{e_pop_num} (country level population). If \code{stat} is set to \code{rate} or
\code{prop} then this is the parameter to use as the denominator.}

\item{rate_scale}{Numeric defaults to 100,000. The scaling to use for rates. If \code{stat} is to set to \code{prop} then this defaults
to 1.}

\item{truncate_at_zero}{Logical, defaults to \code{TRUE}. Should lower bounds be truncated at zero?}

\item{annual_change}{Logical, defaults to \code{FALSE}. If \code{TRUE} then the
percentage annual change is computed for the specified metric.}

\item{smooth}{Logical, defaults to \code{FALSE}. Should the data be smoothed (using \code{ggplot2::geom_smooth})
prior to plotting. If set to \code{TRUE} then the confidence intervals shown are derived from the smooth
and do not represent the underlying uncertainty in the data.}

\item{facet}{Character string, the name of the variable to facet by.}

\item{legend}{Character string, defaults to \code{"top"}. Position of the legend see \code{?ggplot2::theme} for defaults but known
options are: \code{"none"}, \code{"top"}, \code{"right"} and \code{"bottom"}.}

\item{trans}{A character string specifying the transform to use on the specified metric. Defaults to no
transform ("identity"). Other options include log scaling ("log") and log base 10 scaling
("log10"). For a complete list of options see \code{ggplot2::continous_scale}.}

\item{scales}{Character string, see ?ggplot2::facet_wrap for details. Defaults to "fixed",
alternatives are "free_y", "free_x", or "free".}

\item{interactive}{Logical, defaults to \code{FALSE}. If \code{TRUE} then an interactive plot is
returned.}

\item{viridis_palette}{Character string indicating the \code{viridis} colour palette to use. Defaults
to "viridis". Options include "cividis", "magma", "inferno", "plasma", and "viridis". For additional details
see \code{\link[viridis]{viridis_pal}} for additional details.}

\item{viridis_direction}{Numeric, indicating the direction for the colour palette (1 or -1), defaults to -1.
See \code{\link[viridis]{scale_color_viridis}} for additional details.}

\item{viridis_end}{Numeric between 0 and 1, defaults to 0.9. The end point of the viridis scale to use.
#' See \code{\link[viridis]{scale_color_viridis}} for additional details.}

\item{download_data}{Logical, defaults to \code{TRUE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{TRUE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}

\item{...}{Additional arguments to pass to \code{\link[getTBinR]{get_tb_burden}}.}
}
\value{
A plot of TB Incidence Rates by Country
}
\description{
Plot summaries  of TB burden metrics by region, globally, and for custom groupings. For variables with
uncertainty represented by confidence intervals bootstrapping can be used (assuming a normal distribution) to
include this in any estimated summary measures. Currently four statistics are supported; the mean (with
95\% confidence intervals) and the median (with 95\% interquartile range), rates and proportions.
}
\examples{

## Get an overview of incidence rates regionally and globally compared to the UK
plot_tb_burden_summary(metric = "e_inc_num",
                       metric_label = "e_inc_100k",
                       stat = "rate",
                       countries = "United Kingdom", 
                       compare_to_world = TRUE, 
                       compare_all_regions = TRUE,
                       verbose = FALSE,
                       scales = "free_y",
                       facet = "Area") 
\dontrun{


## Get summary data for the UK, Europe and the world
## Bootstrapping CI's 
plot_tb_burden_summary(metric = "e_inc_num",
                       samples = 100,
                       stat = "mean",
                       countries = "United Kingdom", 
                       compare_to_world = TRUE, 
                       compare_to_region = TRUE,
                       verbose = FALSE,
                       facet = "Area",
                       scales = "free_y")
                    
}                     
}
\seealso{
search_data_dict plot_tb_burden summarise_tb_burden

summarise_tb_burden get_tb_burden search_data_dict
}
