% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_df_plot.R
\name{prepare_df_plot}
\alias{prepare_df_plot}
\title{Generic Function to Prepare TB Burden Data for Plotting}
\usage{
prepare_df_plot(df = NULL, dict = NULL, metric = "e_inc_100k",
  metric_label = NULL, countries = NULL, compare_to_region = FALSE,
  facet = NULL, download_data = FALSE, save = FALSE,
  burden_save_name = "TB_burden", dict_save_name = "TB_data_dict",
  verbose = TRUE, ...)
}
\arguments{
\item{df}{Dataframe of TB burden data, as sourced by \code{\link[getTBinR]{get_tb_burden}}.
If not specified then will source the WHO TB burden data, either locally if available
or directly from the WHO (if \code{download_data = TRUE}).}

\item{dict}{A tibble of the data dictionary. See \code{\link[getTBinR]{get_data_dict}}
for details. If not supplied the function will attempt to load a saved version of the
dictionary. If this fails and \code{download_data = TRUE} then the dictionary will be downloaded.}

\item{metric}{Character string specifying the metric to plot}

\item{metric_label}{Character string specifying the metric label to use.}

\item{countries}{A character string specifying the countries to plot.}

\item{compare_to_region}{Logical, defaults to \code{FALSE}. If \code{TRUE} all
countries that share a region with those listed in \code{countries} will be plotted.
Note that this will override settings for \code{facet}, unless it is set to "country".}

\item{facet}{Character string, the name of the variable to facet by.}

\item{download_data}{Logical, defaults to \code{FALSE}. If not found locally should the data be
downloaded from the specified URL?}

\item{save}{Logical, should the data be saved for reuse during the current R session. Defaults to
\code{FALSE}. If \code{TRUE} then the data is saved to the temporary directory specified by \code{\link[base]{tempdir}}.}

\item{burden_save_name}{Character string, name to save the data under. Defaults to
\code{TB_burden}.}

\item{dict_save_name}{Character string, name to save dictionary under. Defaults to
\code{TB_data_dict}.}

\item{verbose}{Logical, defaults to \code{TRUE}. Should additional status and progress messages
be displayed.}

\item{...}{Additional parameters to pass to \code{\link[getTBinR]{get_tb_burden}}.}
}
\value{
A list containing 3 elements, the dataframe to plot, the facet to use and
the label to assign to the metric axis.
}
\description{
This function is used internally by \code{\link[getTBinR]{plot_tb_burden}}
and \code{\link[getTBinR]{plot_tb_burden_overview}} to prepare data for plotting.
}
\examples{

prepare_df_plot(countries = "Guinea", download_data = TRUE, save = TRUE)

}
\seealso{
plot_tb_burden plot_tb_burden_overview
}
