% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GermIndex.R
\name{GermIndex}
\alias{GermIndex}
\title{Germination Index}
\usage{
GermIndex(
  germ.counts,
  intervals,
  partial = TRUE,
  total.seeds,
  modification = c("none", "santanaranal")
)
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial
or cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{total.seeds}{Total number of seeds.}

\item{modification}{The modification to be applied. Either \code{"none"} or
\code{"santanaranal"}. Default is \code{"none"} (see \strong{Details}).}
}
\value{
The value of the Germination index.
}
\description{
Compute the Germination index according to
\insertCite{melvilleSeedGerminationEarly1980;textual}{germinationmetrics} and
its modification by
\insertCite{de_santana_alise_2004;textual}{germinationmetrics}
\insertCite{ranal_how_2006}{germinationmetrics}. \loadmathjax
}
\details{
Germination index (\mjseqn{GI}) is computed as follows
\insertCite{melvilleSeedGerminationEarly1980}{germinationmetrics}.

\mjsdeqn{GI = \sum_{i=1}^{k}\frac{\left | \left ( T_{k} - T_{i} \right )
N_{i}\right |}{N_{t}}}

Where, \mjseqn{T_{i}} is the time from the start of the experiment to the
\mjseqn{i}th interval (day for the example), \mjseqn{N_{i}} is the number of
seeds germinated in the \mjseqn{i}th time interval (not the accumulated
number, but the number corresponding to the \mjseqn{i}th interval),
\mjseqn{N_{t}} is the total number of seeds used in the test, and \mjseqn{k}
is the total number of time intervals.

A modified germination index (\mjseqn{GI_{mod}}) was proposed by
\insertCite{de_santana_alise_2004}{germinationmetrics} where total number of
seeds tested (\mjseqn{N{t}}) is replaced by the total number of germinated
seeds (\mjseqn{N{g}}) in the expression of
\insertCite{melvilleSeedGerminationEarly1980;textual}{germinationmetrics} to
remove the effect of sample size
\insertCite{ranal_how_2006}{germinationmetrics}.

\mjsdeqn{GI_{mod} = \sum_{i=1}^{k}\frac{\left | \left ( T_{k} - T_{i} \right
) N_{i}\right |}{N_{g}}}

The term Germination index (\mjseqn{GI}) has also been used to describe the
mathematical expression for Speed of germination
(\code{\link[germinationmetrics]{GermSpeed}}) by
\insertCite{aosa_seed_1983;textual}{germinationmetrics}.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
GermIndex(germ.counts = x, intervals = int, total.seeds = 50)
GermIndex(germ.counts = x, intervals = int, total.seeds = 50,
          modification = "none")
GermIndex(germ.counts = x, intervals = int, total.seeds = 50,
          modification = "santanaranal")

# From cumulative germination counts
#----------------------------------------------------------------------------
GermIndex(germ.counts = y, intervals = int, partial = FALSE,
          total.seeds = 50)
GermIndex(germ.counts = y, intervals = int, partial = FALSE,
          total.seeds = 50,
          modification = "none")
GermIndex(germ.counts = y, intervals = int, partial = FALSE,
          total.seeds = 50,
          modification = "santanaranal")

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link[germinationmetrics]{GermSpeed}}
}
