% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/t50.R
\name{t50}
\alias{t50}
\title{Median germination time}
\usage{
t50(germ.counts, intervals, partial = TRUE, method = c("coolbear",
  "farooq"))
}
\arguments{
\item{germ.counts}{Germination counts at each time interval. Can be partial or
cumulative as specified in the argument \code{partial}.}

\item{intervals}{The time intervals.}

\item{partial}{logical. If \code{TRUE}, \code{germ.counts} is considered as
partial and if \code{FALSE}, it is considered as cumulative. Default is
\code{TRUE}.}

\item{method}{The method for computing median germination time. Either
\code{"coolbear"} or \code{"farooq"}.}
}
\value{
The median germination time
 (\ifelse{html}{\out{<em>t<sub>50</sub></em>}}{\eqn{t_{50}}}) value in the
 same unit of time as specified in the argument \code{intervals}.
}
\description{
Compute the median germination time
(\ifelse{html}{\out{<em>t<sub>50</sub></em>}}{\eqn{t_{50}}}). Median
germination time is the time to reach 50\% of final/maximum germination.
}
\details{
With argument \code{method} specified as \code{"coolbear"}, median germination
time is computed according to the formula by Coolbear et al., 1984 as follows:

\ifelse{html}{\out{<p style="text-align: center;"><em>t<sub>50</sub> =
T<sub>i</sub> + [ <sup>(((<sup>(N+1)</sup> &frasl; <sub>2</sub> ) &minus;
N<sub>i</sub>)(T<sub>j</sub> &minus; T<sub>i</sub>))</sup> &frasl;
<sub>(N<sub>j</sub> &minus;
N<sub>i</sub>)</sub>]</em></p>}}{\deqn{t_{50}=T_{i}+
\frac{(\frac{N+1}{2}-N_{i})(T_{j}-T_{i})}{N_{j}-N_{i}}}}

Where, \ifelse{html}{\out{<em>t<sub>50</sub></em>}}{\eqn{t_{50}}} is the
median germination time, \ifelse{html}{\out{<i>N</i>}}{\eqn{N}} is the final number of germinated seeds and
\ifelse{html}{\out{<em>N<sub>i</sub></em>}}{\eqn{N_{i}}} and
\ifelse{html}{\out{<em>N<sub>j</sub></em>}}{\eqn{N_{j}}} are the total number
of seeds germinated in adjacent counts at time
\ifelse{html}{\out{<em>T<sub>i</sub></em>}}{\eqn{T_{i}}} and
\ifelse{html}{\out{<em>T<sub>j</sub></em>}}{\eqn{T_{j}}} respectively, when
\ifelse{html}{\out{<em>N<sub>i</sub>&nbsp;&lt;&nbsp;<sup>(N+1)</sup>&nbsp;&frasl;&nbsp;<sub>2</sub>&nbsp;&lt;&nbsp;N<sub>j</sub></em>}}{\eqn{N_{i}
< \frac{N + 1}{2} < N_{j}}}.

Similarly with argument \code{method} specified as \code{"farooq"}, median
germination time is computed according to the formula by  by Farooq et al.,
2005 as follows:

\ifelse{html}{\out{<p style="text-align: center;"><em>t<sub>50</sub> =
T<sub>i</sub> + [ <sup>(((<sup>N</sup> &frasl; <sub>2</sub> ) &minus;
N<sub>i</sub>)(T<sub>j</sub> &minus; T<sub>i</sub>))</sup> &frasl;&nbsp;
<sub>(N<sub>j</sub> &minus;
N<sub>i</sub>)</sub>]</em></p>}}{\deqn{t_{50}=T_{i}+
\frac{(\frac{N}{2}-N_{i})(T_{j}-T_{i})}{N_{j}-N_{i}}}}

Where, \ifelse{html}{\out{<em>t<sub>50</sub></em>}}{\eqn{t_{50}}} is the
median germination time, \ifelse{html}{\out{<i>N</i>}}{\eqn{N}} is the final number of germinated seeds and
\ifelse{html}{\out{<em>N<sub>i</sub></em>}}{\eqn{N_{i}}} and
\ifelse{html}{\out{<em>N<sub>j</sub></em>}}{\eqn{N_{j}}} are the total number
of seeds germinated in adjacent counts at time
\ifelse{html}{\out{<em>T<sub>i</sub></em>}}{\eqn{T_{i}}} and
\ifelse{html}{\out{<em>T<sub>j</sub></em>}}{\eqn{T_{j}}} respectively, when
\ifelse{html}{\out{<em>N<sub>i</sub>&nbsp;&lt;&nbsp;<sup>N</sup>&frasl;<sub>2</sub>&nbsp;&lt;&nbsp;N<sub>j</sub></em>}}{\eqn{N_{i}
< \frac{N}{2} < N_{j}}}.
}
\examples{
x <- c(0, 0, 0, 0, 4, 17, 10, 7, 1, 0, 1, 0, 0, 0)
y <- c(0, 0, 0, 0, 4, 21, 31, 38, 39, 39, 40, 40, 40, 40)
int <- 1:length(x)

# From partial germination counts
#----------------------------------------------------------------------------
t50(germ.counts = x, intervals = int, method = "coolbear")
t50(germ.counts = x, intervals = int, method = "farooq")

# From cumulative germination counts
#----------------------------------------------------------------------------
t50(germ.counts = y, intervals = int, partial = FALSE, method = "coolbear")
t50(germ.counts = y, intervals = int, partial = FALSE, method = "farooq")

}
\references{
\insertRef{coolbear_effect_1984}{germinationmetrics}

\insertRef{farooq_thermal_2005}{germinationmetrics}
}
\seealso{
\code{\link[germinationmetrics]{MeanGermRate}}
}
