% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilZ.R
\name{interZoneC}
\alias{interZoneC}
\title{interZoneC}
\usage{
interZoneC(Z, iC, iZC, closePt)
}
\arguments{
\item{Z}{zoning geometry (list of SpatialPolygons)}

\item{iC}{zone number}

\item{iZC}{other zone number}

\item{closePt}{SpatialPoints object in other zone used as circle center}
}
\value{
a list with components
\describe{
  \item{spi}{Two SpatialPoints to be used for the junction of the two zones}
  \item{ord}{Order in which to use the points}
}
}
\description{
interZoneC
}
\details{
finds two intersection points of a circle with a zone. The circle radius is chosen so that it will intersect both zones given as arguments.
}
\examples{
\donttest{
data(mapTest)
qProb=c(0.2,0.5)
ZK = initialZoning(qProb, mapTest)
K=ZK$resZ
Z=K$zonePolygone
plotZ(K$zonePolygone) # zoning
closePt = geozoning:::getClosePt(Z,6,8)
points(closePt,col="red")
res  = geozoning:::interZoneC(Z,6,8,closePt)
points(res$spi,col="red")
}
}
\keyword{internal}
