% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fractals.R
\name{sizefrequency}
\alias{sizefrequency}
\title{calculate the size-frequency distribution of things}
\usage{
sizefrequency(dat, n = 10, log = TRUE)
}
\arguments{
\item{dat}{a numerical vector}

\item{n}{the number of sizes to evaluate}

\item{log}{logical. If \code{TRUE}, uses a log spacing for the
sizes at which the frequencies are evaluated}
}
\value{
a data frame with two columns \code{size} and
    \code{frequency}
}
\description{
Count the number of items exceeding a certain size.
}
\examples{
data(Finland,package='geostats')
sf <- sizefrequency(Finland$area)
plot(frequency~size,data=sf,log='xy')
fit <- lm(log(frequency) ~ log(size),data=sf)
lines(x=sf$size,y=exp(predict(fit)))
}
