% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternary.R
\name{ternary}
\alias{ternary}
\title{ternary diagrams}
\usage{
ternary(xyz = NULL, f = rep(1, 3), labels, add = FALSE, type = "p", ...)
}
\arguments{
\item{xyz}{an \code{n x 3} matrix or data frame}

\item{f}{a three-element vector of multipliers for \code{xyz}}

\item{labels}{the text labels for the corners of the ternary
diagram}

\item{add}{if \code{TRUE}, adds information to an existing ternary
diagram}

\item{type}{one of \code{'n'} (empty plot), \code{'p'} (points),
\code{'l'} (lines) or \code{'t'} (text).}

\item{...}{optional arguments to the \code{points}, \code{lines} or
\code{text} functions.}
}
\description{
Plot points, lines or text on a ternary diagram.
}
\examples{
data(ACNK,package='geostats')
ternary(ACNK,type='p',labels=c(expression('Al'[2]*'O'[3]),
                               expression('CaO+Na'[2]*'O'),
                               expression('K'[2]*'O')))
}
