% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{FROM_GeoJson_Schema}
\alias{FROM_GeoJson_Schema}
\title{reads GeoJson data using a one-word-schema}
\usage{
FROM_GeoJson_Schema(url_file_string, geometry_name = "",
  Average_Coordinates = FALSE, To_List = FALSE)
}
\arguments{
\item{url_file_string}{a string specifying the input path to a file OR a geojson object (in form of a character string) OR a valid url (beginning with 'http..') pointing to a geojson object}

\item{geometry_name}{a string specifying the geometry name in the geojson string/file. The \emph{geometry_name} functions as a one-word schema and can significantly speed up the parsing of the data.}

\item{Average_Coordinates}{either TRUE or FALSE. If TRUE then additionally a geojson-dump and the average latitude and longitude of the geometry object will be returned.}

\item{To_List}{either TRUE or FALSE. If TRUE then the \emph{coordinates} of the geometry object will be returned in form of a list, otherwise in form of a numeric matrix.}
}
\value{
a (nested) list
}
\description{
reads GeoJson data using a one-word-schema
}
\details{
This function is appropriate when the property-names do not match exactly the 'RFC 7946' specification ( for instance if the \emph{geometry} object-name appears as \emph{location} as is the case sometimes in mongodb queries ).
The user can then specify the \emph{geometry_name} as it exactly appears in the .geojson string/file (consult the example for more details). If no \emph{geometry_name} is given then recursion will be used, which increases the processing time.
In case that the input .geojson object is of \emph{type} : \emph{Point}, \emph{LineString}, \emph{MultiPoint}, \emph{Polygon}, \emph{GeometryCollection}, \emph{MultiLineString}, \emph{MultiPolygon},
 \emph{Feature} or \emph{FeatureCollection} with a second attribute name : \emph{coordinates}, then the \emph{geometry_name} parameter is not necessary.
}
\examples{

library(geojsonR)


# INPUT IS A GEOJSON (character string)

tmp_str = '{
            "name" : "example_name",
            "location" : {
                "type" : "Point",
                "coordinates" : [ -120.24, 39.21 ]
              }
           }'

res = FROM_GeoJson_Schema(url_file_string = tmp_str, geometry_name = "location")

}
