% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/causeSummary.R
\name{causeSummary}
\alias{causeSummary}
\title{Function for kernel causality summary of results}
\usage{
causeSummary(mtx, nam = colnames(mtx), ctrl = 0, dig = 6, wt = c(1.2,
  1.1, 1.05, 1), sumwt = 4)
}
\arguments{
\item{mtx}{{The data matrix with many columns, y the first column is fixed and then 
paired with all columns, one by one, and still called x for the purpose of flipping.}}

\item{nam}{{vector of column names for \code{mtx}. Default: colnames(mtx)}}

\item{ctrl}{{data matrix for designated control variable(s) outside causal paths}}

\item{dig}{{Number of digits for reporting (default \code{dig}=6).}}

\item{wt}{{Allows user to choose a vector of four alternative weights for SD1 to SD4.}}

\item{sumwt}{{ Sum of weights can be changed here =4(default).}}
}
\value{
If there are p columns in the input matrix, there are p-1 possible
flipped X, Y pairs leaving the control variables alone.  
This function prints the results for p-1 pairs indicating which causes what
it also prints strength or signed summary index in range [-100,100] 
In general, a positive sign means first input variable causes the second, etc
that the first variable listed as the input to this function is the `kernel cause,' 
whereas negative strength index means second column variable causes the first.
Also, it prints Pearson correlation and its p-value. This function also returns
a matrix of p-1 rows and 5 columns providing summary of causal results.
the first column names the causal variable and second names the response.
the third column has absolute value of summary index in range [0,100] 
summarizing preponderance of evidence from Cr1 to Cr3 
from four orders of stochastic dominance, etc.  The order of input columns matters.
the fourth column of the output matrix has Pearson correlation coefficient
the fifth column has the p-value for testing the null of zero Pearson coeff.
Suggested column headings are Cause, Response, Strength, r, p-value
This function calls  \code{silentPairs} allowing for control variables.
}
\description{
Allowing input matrix of control variables, this function produces a 5 column matrix
summarizing the results where the estimated signs of
stochastic dominance order values (+1, 0, -1) are weighted by 
 \code{wt=c(1.2,1.1, 1.05, 1)} to
compute an overall result for all orders of stochastic dominance by a weighted sum for
the crietria Cr1 and Cr2 and added to the Cr3 estimate as: (+1, 0, -1).
}
\details{
The reason for slightly declining weights on the signs from
SD1 to SD4 is simply that the local mean comparisons 
implicit in SD1 are known to be
more reliable than local variance implicit in SD2, local skewness implicit in
SD3 and local kurtosis implicit in SD4. The reason for slightly declining sampling
unreliability of higher moments is simply that SD4 involves fourth power
of the deviations from the mean and SD3 involves 3rd power, etc.
The summary results for all
three criteria are reported in one matrix called \code{out}:
}
\note{
The European Crime data has all three criteria correctly suggesting that
high crime rate kernel causes the deployment of a large number of police officers.
Cr1 to Cr3 unanimously suggest `crim' as the cause of `off', so index is 100.
}
\examples{


\dontrun{
mtx=as.matrix(mtcars[,1:3])
ctrl=as.matrix(mtcars[,4:5])
 causeSummary(mtx,ctrl,nam=colnames(mtx))
}

options(np.messages=FALSE)
set.seed(234)
z=runif(10,2,11)# z is independently created
x=sample(1:10)+z/10 #x is somewhat indep and affected by z
y=1+2*x+3*z+rnorm(10)
w=runif(10)
x2=x;x2[4]=NA;y2=y;y2[8]=NA;w2=w;w2[4]=NA
causeSummary(mtx=cbind(x2,y2), ctrl=cbind(z,w2))


}
\references{
Vinod, H. D. 'Generalized Correlation and Kernel Causality with
   Applications in Development Economics' in Communications in
   Statistics -Simulation and Computation, 2015,
   \url{http://dx.doi.org/10.1080/03610918.2015.1122048}
}
\seealso{
See  \code{\link{bootPairs}}

See  \code{\link{someCPairs}}

\code{\link{silentPairs}}
}
\author{
Prof. H. D. Vinod, Economics Dept., Fordham University, NY.
}
\keyword{SD1,}
\keyword{SD2,}
\keyword{SD3,}
\keyword{SD4,}
\keyword{causal}
\keyword{index}
\keyword{path,}
\keyword{summary}
