% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IO.R
\name{import_AccINFO}
\alias{import_AccINFO}
\title{Import Accession Information from File}
\usage{
import_AccINFO(file, comment.char = "#",
               check.names = FALSE, row.names = 1, ...)
}
\arguments{
\item{file}{file path, this file should be a tab delimed table}

\item{comment.char}{character: a character vector of length one
    containing a single character or an empty string.  Use \code{""} to
    turn off the interpretation of comments altogether.}

\item{check.names}{logical.  If \code{TRUE} then the names of the
    variables in the data frame are checked to ensure that they are
    syntactically valid variable names.  If necessary they are adjusted
    (by \code{\link{make.names}}) so that they are, and also to ensure
    that there are no duplicates.}

\item{row.names}{a vector of row names.  This can be a vector giving
    the actual row names, or a single number giving the column of the
    table which contains the row names, or character string giving the
    name of the table column containing the row names.

    If there is a header and the first row contains one fewer field than
    the number of columns, the first column in the input is used for the
    row names.  Otherwise if \code{row.names} is missing, the rows are
    numbered.

    Using \code{row.names = NULL} forces row numbering. Missing or
    \code{NULL} \code{row.names} generate row names that are considered
    to be \sQuote{automatic} (and not preserved by \code{\link{as.matrix}}).
  }

\item{...}{Further arguments to be passed to \code{read.table}.}
}
\value{
data.frame, Accession names were set as rownames and columns were
named by pheno/info names
}
\description{
import accession information including phenotype data,
accession group, location from a tab delimed table file
}
\details{
First column should be Accessions;
phenos/accession information should begin from second column,
phenoName/group/locations should located at the first row,
If a dot '.' is located in pheno name, then
the part before the dot will be set as y axis name
and the latter will be set as foot when plot figures.
}
\examples{

oldDir <- getwd()
setwd(tempdir())
data("geneHapR_test")
write.table(pheno, file = "test.pheno.txt", sep = "\t")
pheno <- import_AccINFO("test.pheno.txt")
pheno
setwd(oldDir)

}
