% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functionalSites.R
\name{plotEFF}
\alias{plotEFF}
\title{plotEFF}
\usage{
plotEFF(siteEFF, gff = gff,
        Chr = Chr, start = start, end = end,
        showType = c("five_prime_UTR", "CDS", "three_prime_UTR"),
        CDS.height = 1, cex = 0.1, col = col, pch = 20,
        main = main, legend.cex = 0.8, legend.ncol = legend.ncol,
        markMutants = TRUE, mutants.col = 1, mutants.type = 1,
        ylab = "effect")
}
\arguments{
\item{siteEFF}{matrix, column name are pheno names and row name are site position}

\item{gff}{gff}

\item{Chr}{the chromosome name}

\item{start}{start postion}

\item{end}{end position}

\item{showType}{character vector, eg.: "CDS", "five_prime_UTR",
"three_prime_UTR"}

\item{CDS.height}{numeric indicate the height of CDS in gene model,
range: \verb{[0,1]}}

\item{cex}{a numeric control the size of point}

\item{col}{vector controls points color, see
\code{\link[graphics:points]{points()}}}

\item{pch}{vector controls points type, see
\code{\link[graphics:par]{par()}}}

\item{main}{main title}

\item{legend.cex}{a numeric control the legend size}

\item{legend.ncol}{the number of columns in which to set the legend items}

\item{markMutants}{whether mark mutants on gene model, default as \code{TRUE}}

\item{mutants.col}{color of lines which mark mutants}

\item{mutants.type}{a vector of line types}

\item{ylab}{character, yaxis label}
}
\value{
No return value, called for side effects
}
\description{
plotEFF
}
\examples{
\donttest{
data("geneHapR_test")

# calculate site functional effect
siteEFF <- siteEFF(hapResult, pheno, names(pheno))
plotEFF(siteEFF, gff = gff, Chr = "scaffold_1")
}
}
