% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{get_cache_max}
\alias{get_cache_max}
\title{Get the maximum memory size available for the GDAL block cache}
\usage{
get_cache_max(units = "MB")
}
\arguments{
\item{units}{Character string specifying units for the return value. One of
\code{"MB"} (the default), \code{"GB"}, \code{"KB"} or \code{"bytes"} (values of \code{"byte"},
\code{"B"} and empty string \code{""} are also recognized to mean bytes).}
}
\value{
A numeric value carrying the \code{integer64} class attribute. Maximum
cache memory available in the requested units.
}
\description{
\code{get_cache_max()} returns the maximum amount of memory available to the
GDALRasterBlock caching system for caching raster read/write data. Wrapper
of \code{GDALGetCacheMax64()} with return value in MB by default.
}
\details{
The first time this function is called, it will read the \code{GDAL_CACHEMAX}
configuration option to initialize the maximum cache memory. The value of
the configuration option can be expressed as x\% of the usable physical RAM
(which may potentially be used by other processes). Otherwise it is
expected to be a value in MB.
As of GDAL 3.10, the default value, if \code{GDAL_CACHEMAX} has not been set
explicitly, is 5\% of usable physical RAM.
}
\note{
The value of the \code{GDAL_CACHEMAX} configuration option is only consulted the
first time the cache size is requested (i.e., it must be set as a
configuration option prior to any raster I/O during the current session).
To change this value programmatically during operation of the program it is
better to use \code{\link[=set_cache_max]{set_cache_max()}} (in which case, always given in bytes).
}
\examples{
get_cache_max()
}
\seealso{
\href{https://gdal.org/en/stable/user/configoptions.html#performance-and-caching}{GDAL_CACHEMAX configuration option}

\code{\link[=get_config_option]{get_config_option()}}, \code{\link[=set_config_option]{set_config_option()}}, \code{\link[=get_usable_physical_ram]{get_usable_physical_ram()}},
\code{\link[=get_cache_used]{get_cache_used()}}, \code{\link[=set_cache_max]{set_cache_max()}}
}
