% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_optim_parameters.R
\name{extract_optim_parameters.galamm}
\alias{extract_optim_parameters.galamm}
\alias{extract_optim_parameters}
\title{Extract parameters from fitted model for use as initial values}
\usage{
\method{extract_optim_parameters}{galamm}(object)
}
\arguments{
\item{object}{Object of class \code{galamm} returned from
\code{\link{galamm}}.}
}
\value{
A \code{list} object containing the following elements:
\itemize{
\item \code{theta} Numerical vector of variance components, i.e., entries of
the lower Cholesky form of the covariance matrix of random effects.
\item \code{beta} Fixed regression coefficients.
\item \code{lambda} Factor loadings.
\item \code{weights} Weights for heteroscedastic residuals.
}
}
\description{
This function extracts parameter values from a fitted model object in a form
that can be directly provided as initial values for a new model fit.
}
\examples{
# Fit linear mixed model with heteroscedastic residuals
mod <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced
)

# Extract parameters
start <- extract_optim_parameters(mod)

# Fit again using the Nelder-Mead algorithm, using start as initial values:
mod_nm <- galamm(
  formula = y ~ x + (1 | id),
  weights = ~ (1 | item),
  data = hsced,
  start = start,
  control = galamm_control(method = "Nelder-Mead")
)

}
\seealso{
Other optimization functions: 
\code{\link{galamm_control}()}
}
\concept{optimization functions}
