% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fd_fdiv.R
\name{fd_fdiv}
\alias{fd_fdiv}
\title{Compute Functional Divergence (FDiv)}
\usage{
fd_fdiv(traits, sp_com)
}
\arguments{
\item{traits}{The matrix dataset for which you want to compute the index}

\item{sp_com}{Site-species matrix with sites as rows and species as columns
if not provided, the function considers all species with equal
abundance in a single site. This can be either a \code{matrix},
a \code{data.frame}, or a \code{\link[Matrix:Matrix]{Matrix::Matrix()}} object.
package.}
}
\value{
a data.frame with two columns:
\itemize{
\item \code{site} the names of the sites as the row names of the input \code{sp_com},
\item \code{FDiv} the values of functional divergence at each site.
}
}
\description{
Compute Functional Divergence (FDiv)
}
\examples{
data(traits_birds)
fd_fdiv(traits_birds)

}
\references{
Villéger S., Mason N. W. H., Mouillot D. (2008), New multidimensional
functional diversity indices for a multifaceted framework in functional
ecology, Ecology 89(8), \doi{10.1890/07-1206.1}
}
