% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PseKRAAC_T10.R
\name{PseKRAAC_T10}
\alias{PseKRAAC_T10}
\title{Pseudo K_tuple Reduced Amino Acid Composition Type-10 (PseKRAAC_T10)}
\usage{
PseKRAAC_T10(
  seqs,
  type = "gap",
  Grp = 5,
  GapOrLambdaValue = 2,
  k = 4,
  label = c()
)
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{type}{This parameter has two valid value "lambda" and "gap". "lambda"
calls lambda_model function and "gap" calls gap_model function.}

\item{Grp}{is a numeric value. It shows the id of an amino acid group.
Please find the available groups in the detail section.}

\item{GapOrLambdaValue}{is an integer.
If type is gap, this value shows number of gaps between two k-mers.
If type is lambda, the value of GapOrLambdaValue shows the number of gaps between each two amino acids of k-mers.}

\item{k}{This parameter keeps the value of k in k-mer.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}
}
\value{
This function returns a feature matrix. The number of rows is equal to the number of sequences and
the number of columns is (Grp)^k.
}
\description{
There are 16 types of PseKRAAC function.
In the functions, a (user-selected) grouping of the amino acids might be used to reduce the amino acid alphabet.
Also, the functions have a type parameter.
The parameter determines the protein sequence analyses which can be either gap or lambda-correlation.
PseKRAAC_type10(PseKRAAC_T10) contains Grp 2-20.
}
\details{
Groups:
2=c('CMFILVWY', 'AGTSNQDEHRKP'),
3=c('CMFILVWY', 'AGTSP', 'NQDEHRK'),
4=c('CMFWY', 'ILV', 'AGTS', 'NQDEHRKP'),
5=c('FWYH', 'MILV', 'CATSP', 'G', 'NQDERK'),
6=c('FWYH', 'MILV', 'CATS', 'P', 'G', 'NQDERK'),
7=c('FWYH', 'MILV', 'CATS', 'P', 'G', 'NQDE', 'RK'),
8=c('FWYH', 'MILV', 'CA', 'NTS', 'P', 'G', 'DE', 'QRK'),
9=c('FWYH', 'ML', 'IV', 'CA', 'NTS', 'P', 'G', 'DE', 'QRK'),
10=c('FWY', 'ML', 'IV', 'CA', 'TS', 'NH', 'P', 'G', 'DE', 'QRK'),
11=c('FWY', 'ML', 'IV', 'CA', 'TS', 'NH', 'P', 'G', 'D', 'QE', 'RK'),
12=c('FWY', 'ML', 'IV', 'C', 'A', 'TS', 'NH', 'P', 'G', 'D', 'QE', 'RK'),
13=c('FWY', 'ML', 'IV', 'C', 'A', 'T', 'S', 'NH', 'P', 'G', 'D', 'QE', 'RK'),
14=c('FWY', 'ML', 'IV', 'C', 'A', 'T', 'S', 'NH', 'P', 'G', 'D', 'QE', 'R', 'K'),
15=c('FWY', 'ML', 'IV', 'C', 'A', 'T', 'S', 'N', 'H', 'P', 'G', 'D', 'QE', 'R', 'K'),
16=c('W', 'FY', 'ML', 'IV', 'C', 'A', 'T', 'S', 'N', 'H', 'P', 'G', 'D', 'QE', 'R', 'K'),
17=c('W', 'FY', 'ML', 'IV', 'C', 'A', 'T', 'S', 'N', 'H', 'P', 'G', 'D', 'Q', 'E', 'R', 'K'),
18=c('W', 'FY', 'M', 'L', 'IV', 'C', 'A', 'T', 'S', 'N', 'H', 'P', 'G', 'D', 'Q', 'E', 'R', 'K'),
19=c('W', 'F', 'Y', 'M', 'L', 'IV', 'C', 'A', 'T', 'S', 'N', 'H', 'P', 'G', 'D', 'Q', 'E', 'R', 'K'),
20=c('W', 'F', 'Y', 'M', 'L', 'I', 'V', 'C', 'A', 'T', 'S', 'N', 'H', 'P', 'G', 'D', 'Q', 'E', 'R', 'K')
}
\examples{

filePrs<-system.file("extdata/proteins.fasta",package="ftrCOOL")

mat1<-PseKRAAC_T10(seqs=filePrs,type="gap",Grp=4,GapOrLambdaValue=3,k=2)

mat2<-PseKRAAC_T10(seqs=filePrs,type="lambda",Grp=4,GapOrLambdaValue=3,k=2)
}
\references{
Zuo, Yongchun, et al. "PseKRAAC: a flexible web server for generating pseudo K-tuple reduced amino acids composition." Bioinformatics 33.1 (2017): 122-124.
}
