% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zSCALE.R
\name{zSCALE}
\alias{zSCALE}
\title{Z-SCALE (zSCALE)}
\usage{
zSCALE(seqs, label = c(), outFormat = "mat", outputFileDist = "")
}
\arguments{
\item{seqs}{is a FASTA file with amino acid sequences. Each sequence starts
with a '>' character. Also, seqs could be a string vector. Each element of the vector is a peptide/protein sequence.}

\item{label}{is an optional parameter. It is a vector whose length is equivalent to the number of sequences. It shows the class of
each entry (i.e., sequence).}

\item{outFormat}{(output format) can take two values: 'mat'(matrix) and 'txt'. The default value is 'mat'.}

\item{outputFileDist}{shows the path and name of the 'txt' output file.}
}
\value{
The output depends on the outFormat parameter which can be either 'mat' or 'txt'. If outFormat is 'mat', the function returns a feature
matrix for sequences with the same length such that the number of columns is (sequence length)*(5)
and the number of rows is equal to the number of sequences.
If the outFormat is 'txt', the output is written to a tab-delimited file.
}
\description{
This function converts the amino acids of a sequence to five physicochemical descriptor variables which were developed by Sandberg et al. in 1998.
The Z-SCALE function can be applied to encode peptides of equal length.
}
\note{
This function is provided for sequences with the same lengths.
Users can use 'txt' option in outFormat parameter for sequences with different lengths.
Warning: If outFormat is set to 'mat' for sequences with different lengths, it returns an error.
Also, when output format is 'txt', label information is not shown in the text file.
It is noteworthy that 'txt' format is not usable for machine learning purposes.
}
\examples{

ptmSeqsADR<-system.file("extdata/",package="ftrCOOL")
ptmSeqsVect<-as.vector(read.csv(paste0(ptmSeqsADR,"/ptmVect101AA.csv"))[,2])
mat<-zSCALE(seqs = ptmSeqsVect,outFormat="mat")
}
