% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fqi_metrics.R
\name{FQI}
\alias{FQI}
\title{Calculate FQI}
\usage{
FQI(x, key = "name", db, native = FALSE)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}

\item{native}{Boolean (TRUE or FALSE). If TRUE, calculate metrics using only
native species.}
}
\value{
A non-negative integer
}
\description{
\code{FQI} calculates the Floristic Quality Index (FQI) for the area of concern. FQI is found
by multiplying the mean C by the square root of the species richness. If \code{native = TRUE},
\code{FQI} will calculate the Native FQI.
}
\examples{
plant_list <- crooked_island

#FQI of all species (native and introduced)
FQI(x = plant_list, key = "acronym", db = "michigan_2014", native = FALSE)

#FQI of native species
FQI(x = plant_list, key = "acronym", db = "michigan_2014", native = TRUE)
}
