% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cover_metrics.R
\name{plot_summary}
\alias{plot_summary}
\title{Calculate Plot-level Summary Statistics}
\usage{
plot_summary(
  x,
  key = "name",
  db,
  cover_class = "percent_cover",
  plot_id,
  allow_no_c = TRUE,
  allow_non_veg = TRUE
)
}
\arguments{
\item{x}{A data frame containing a list of plant species. This data frame
must have one of the following columns: \code{name} or \code{acronym}. For cover-weighted or
relative functions, this data frame must also have a column called \code{cover} containing
cover values and ideally a column containing plot IDs.}

\item{key}{A character string representing the column that will be used to join
the input data frame \code{x} with the regional FQA database. If a value is not specified, the
default is \code{"name"}. \code{"name"} and \code{"acronym"} are the only acceptable
values for \code{key}.}

\item{db}{A character string representing the regional FQA database to use. See
\code{db_names} for a list of potential values and the \code{fqadata} R package
where the databases are hosted.}

\item{cover_class}{a character string representing the cover classification used. Acceptable
cover classes are: \code{"percent_cover"}, \code{"carolina_veg_survey"}, \code{"braun-blanquet"},
\code{"daubenmire"}, and \code{"usfs_ecodata"}. \code{"percent_cover"} is the default.}

\item{plot_id}{A character string representing the column in \code{x} that contains plot
identification values. \code{plot_id} is a required argument in \code{plot_summary}, where it acts
as a grouping variable. \code{plot_id} is optional but highly recommended for
cover-weighted functions and relative functions. If \code{plot_id} is set in a
cover-weighted function or a relative function, it only prevents duplicates
from occurring in the same plot. It does not act as a grouping variable.}

\item{allow_no_c}{Boolean (TRUE or FALSE). If TRUE, allow species that are found in the
regional FQA database but have not been assigned a C Values. If FALSE, omit species that have not
been assigned C Values.}

\item{allow_non_veg}{Boolean (TRUE or FALSE). If TRUE, allow input to contain un-vegetated
ground and un-vegetated water.}
}
\value{
A data frame where each row is a plot and columns contain FQI and
cover-weighted FQI statistics.
}
\description{
Input a transect with one or more plots (designated with a unique plot ID) as
a single data frame and the output will be a data frame with plot-level
species richness, native species richness, mean c, native mean c, FQI, native
FQI, adjusted FQI, cover-weighted FQI, and native cover-weighted FQI.
}
\examples{
transect <- transect <- data.frame(
acronym  = c("ABEESC", "ABIBAL", "AMMBRE", "ANTELE", "ABEESC", "ABIBAL", "AMMBRE"),
cover = c(50, 4, 20, 30, 40, 7, 60),
plot_id = c(1, 1, 1, 1, 2, 2, 2))

plot_summary(transect, key = "acronym", db = "michigan_2014",
cover_class = "percent_cover", plot_id = "plot_id")
}
