% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{make_xlim}
\alias{make_xlim}
\title{Create xlim}
\usage{
make_xlim(
  xlim = NULL,
  lower,
  upper,
  ref_line = ifelse(x_trans \%in\% c("log", "log2", "log10"), 1, 0),
  ticks_at = NULL,
  x_trans = "none"
)
}
\arguments{
\item{xlim}{Limits for the x axis as a vector of length 2, i.e. c(low, high). It
will take the minimum and maximum of the lower and upper value if not provided.
This will apply to all CI columns if provided, and will be calculated automatically
for each column if not provided. This should be a list with the same length of
\code{ci_column} if different \code{xlim} for different column is desired.}

\item{lower}{Lower bound of the confidence interval, same as \code{est}.}

\item{upper}{Upper bound of the confidence interval, same as \code{est}.}

\item{ref_line}{X-axis coordinates of zero line, default is 1. Provide an atomic
vector if different reference line for each \code{ci_column} is desired.}

\item{ticks_at}{Set X-axis tick-marks point. This will apply to all CI columns if
provided, and will be calculated automatically for each column if not provided.
This should be a list if different \code{ticks_at} for different column is desired.
Although many efforts have been made to automatically get a pretty ticks break,
it will not give a perfect solution, especially if \code{'log2'} and \code{'log10'}
defined for \code{x_trans}. Please provide this value if possible.}

\item{x_trans}{Change axis scale, Allowed values are one of c("none", "log", "log2",
"log10"). Default is \code{"none"}, no transformation will be applied.
The formatted label will be used for \code{scale  = "log2"} or \code{"log10"}, change
this in \code{x_trans}. Set this to \code{"log"} if x-axis tick marks assume values
are exponential, e.g. for logistic regression (OR), survival estimates (HR), Poisson
regression etc.}
}
\value{
A list
}
\description{
Create xlim based on value ranges.
}
\keyword{internal}
