% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hybridModel.R
\name{plot.hybridModel}
\alias{plot.hybridModel}
\title{Plot a hybridModel object}
\usage{
\method{plot}{hybridModel}(x, type = c("fit", "models"), ...)
}
\arguments{
\item{x}{An object of class hybridModel to plot.}

\item{type}{If \code{type = "fit"}, plot the original series and the individual fitted models.
If \code{type = "models"}, use the regular plot methods from the component models, i.e.
\code{\link{plot.Arima}}, \code{\link{plot.ets}}, \code{\link{plot.tbats}}. Note: no plot
methods exist for \code{nnetar} and \code{stlm} objects, so these will not be plotted with
\code{type = "models"}}

\item{...}{Other arguments (ignored).}
}
\value{
None. Function produces a plot.
}
\description{
Plot a representation of the hybridModel.
}
\details{
For \code{type = "fit"}, the original series is plotted in black. Fitted values for the 
individual component models are plotted in other colors. Prior to the
release of forecast 6.3, stlm objects will be ignored since they
do not contain a \code{\link{fitted}} or \code{\link{residuals}} method.
For \code{type = "models"}, each individual component model is plotted. Since
there is not plot method for \code{stlm} or \code{nnetar} objects, these component
models are not plotted.
}
\examples{
\dontrun{
hm <- hybridModel(woolyrnq, models = "aenst")
plot(hm, type = "fit")
plot(hm, type = "models")
}
}
\seealso{
\code{\link{hybridModel}}
}

