% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation-class.R
\name{interpolation-constructor}
\alias{interpolation-constructor}
\alias{interp_flatforward}
\alias{interp_linear}
\alias{interp_loglinear}
\alias{interp_naturalspline}
\alias{interp_hermitespline}
\alias{interp_monotonespline}
\alias{interp_nelsonsiegel}
\alias{interp_nelsonsiegelsvensson}
\title{Create Interpolation objects}
\usage{
interp_flatforward()

interp_linear()

interp_loglinear()

interp_naturalspline()

interp_hermitespline()

interp_monotonespline()

interp_nelsonsiegel(beta1, beta2, beta3, lambda1)

interp_nelsonsiegelsvensson(beta1, beta2, beta3, beta4, lambda1, lambda2)
}
\arguments{
\item{beta1}{a single numeric}

\item{beta2}{a single numeric}

\item{beta3}{a single numeric}

\item{lambda1}{a single numeric}

\item{beta4}{a single numeric}

\item{lambda2}{a single numeric}
}
\value{
An \code{Interpolation} object.
That object knows the interpolation method but doesn't have the data
points.
When the \code{Interpolation} is set to the curve with \verb{interpolation<-}
the interpolation engine is properly configured.
}
\description{
Functions to create intepolation objects.
}
\details{
\code{interp_flatforward} creates a \code{FlatForward} interpolation object.

\code{interp_linear} creates a \code{Linear} interpolation object.

\code{interp_loglinear} creates a \code{LogLinear} interpolation object.

\code{interp_naturalspline} creates a \code{NaturalSpline} interpolation object.

\code{interp_hermitespline} creates a \code{HermiteSpline} interpolation object.

\code{interp_monotonespline} creates a \code{MonotoneSpline} interpolation object.

\code{interp_nelsonsiegel} creates a \code{NelsonSiegel} interpolation object.
The arguments \code{beta1}, \code{beta2}, \code{beta3}, \code{lambda1} are the paremeters of
the Nelson-Siegel model for term structure.

\code{interp_nelsonsiegelsvensson} creates a \code{NelsonSiegelSvensson}
interpolation object.
The arguments \code{beta1}, \code{beta2}, \code{beta3}, \code{beta4}, \code{lambda1}, \code{lambda2} are
the paremeters of Svensson's extension to Nelson-Siegel the model for
term structure.
}
\examples{
terms <- c(1, 11, 26, 27, 28)
rates <- c(0.0719, 0.056, 0.0674, 0.0687, 0.07)

curve <- spotratecurve(rates, terms, "discrete", "actual/365", "actual")

interpolation(curve) <- interp_flatforward()

curve[[1:10]]
}
\references{
Charles R. Nelson and Andrew F. Siegel (1987), The Journal of Business

Lars E.O. Svensson (1994), National Bureau of Economic Research
}
