% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quick_charts.R
\name{box_plots}
\alias{box_plots}
\title{Plot a series of boxplots}
\usage{
box_plots(data, timeperiod, value, title = "", subtitle = "",
  xlab = "", ylab = "")
}
\arguments{
\item{data}{data.frame object to plot using ggplot2 functions}

\item{timeperiod}{field containing the time period (unquoted)}

\item{value}{field containing variable to be plotted on x axis (unquoted)}

\item{title}{string; title of chart}

\item{subtitle}{string; text to use as subtitle to graph}

\item{xlab}{string; x-axis title}

\item{ylab}{string; y-axis title}
}
\value{
a ggplot of boxplots for many areas over time
}
\description{
Plot a series of boxplots
}
\examples{
\donttest{
# This example is untested because of the time required to retrieve the data
library(fingertipsR)
library(dplyr)
df <- fingertips_data(90366) \%>\%
      filter(Sex == "Male",
      AreaType == "County & UA (pre 4/19)",
      Age == "All ages")
p <- box_plots(df,
               timeperiod = Timeperiod,
               value = Value,
               title = "Life expectancy at birth",
               subtitle = "Males in Uper Tier Local Authorities England",
               ylab = "Age (years)")
p}
}
\seealso{
Other quick charts: \code{\link{compare_areas}},
  \code{\link{compare_indicators}}, \code{\link{map}},
  \code{\link{overview}}, \code{\link{population}},
  \code{\link{trends}}
}
\concept{quick charts}
