% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastcpd_wrappers.R
\name{fastcpd_variance}
\alias{fastcpd_variance}
\alias{fastcpd.variance}
\title{Find change points efficiently in variance change models}
\usage{
fastcpd_variance(data, ...)

fastcpd.variance(data, ...)
}
\arguments{
\item{data}{A matrix, a data frame or a vector.}

\item{...}{Other arguments passed to \code{\link[=fastcpd]{fastcpd()}}, for example,
\code{segment_count}.}
}
\value{
A \linkS4class{fastcpd} object.
}
\description{
\code{\link[=fastcpd_variance]{fastcpd_variance()}} and \code{\link[=fastcpd.variance]{fastcpd.variance()}} are wrapper
functions of \code{\link[=fastcpd]{fastcpd()}} to find the variance change. The
function is similar to \code{\link[=fastcpd]{fastcpd()}} except that the data is by
default a matrix or data frame or a vector with each row / element as an
observation and thus a formula is not required here.
}
\examples{
set.seed(1)
data <- c(rnorm(300, 0, 1), rnorm(400, 0, 100), rnorm(300, 0, 1))
result <- fastcpd.variance(data)
summary(result)
set.seed(1)
p <- 3
result <- fastcpd.variance(
  rbind(
    mvtnorm::rmvnorm(300, rep(0, p), crossprod(matrix(runif(p^2) * 2 - 1, p))),
    mvtnorm::rmvnorm(400, rep(0, p), crossprod(matrix(runif(p^2) * 2 - 1, p))),
    mvtnorm::rmvnorm(300, rep(0, p), crossprod(matrix(runif(p^2) * 2 - 1, p)))
  )
)
summary(result)
\donttest{
set.seed(1)
data <- c(rnorm(3000, 0, 1), rnorm(3000, 0, 2), rnorm(3000, 0, 1))
(result_time <- system.time(
  result <- fastcpd.variance(data, r.progress = FALSE, cp_only = TRUE)
))
result@cp_set
}
\donttest{
set.seed(1)
data <- c(rnorm(3000, 0, 1), rnorm(3000, 0, 2), rnorm(3000, 0, 1))
(result_time <- system.time(
  result <- fastcpd.variance(
    data, beta = "BIC", cost_adjustment = "BIC",
    r.progress = FALSE, cp_only = TRUE
  )
))
result@cp_set
}
}
\seealso{
\code{\link[=fastcpd]{fastcpd()}}
}
