# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' Compute the Wavelet Filter
#'
#' Compute the wavelet filter.
#'
#' @param wavelet A character string indicating the wavelet filter desired
#' @return Wavelet filter vector (a numeric vector)
#' @references
#' Percival, D. B. and A. T. Walden (2000) Wavelet Methods for Time Series Analysis, Cambridge
#' University Press.
wavelet_filter <- function(wavelet) {
    .Call(`_fastWavelets_wavelet_filter`, wavelet)
}

#' Scaling Filter
#'
#' Compute the scaling filter.
#'
#' @param wavelet A character string indicating the scaling filter desired
#' @return Scaling filter vector (a numeric vector)
#' @details The argument `wavelet` can take one of the following values:
#'
#' `c("haar", "d1", "sym1", "bior1.1", "rbio1.1",
#' "d2", "sym2", "d3", "sym3", "d4", "d5", "d6", "d7", "d8", "d9", "d10", "d11",
#' "sym4", "sym5", "sym6", "sym7", "sym8", "sym9", "sym10",
#' "coif1", "coif2", "coif3", "coif4", "coif5",
#' "bior1.3", "bior1.5", "bior2.2", "bior2.4", "bior2.6", "bior2.8", "bior3.1", "bior3.3",
#' "bior3.5", "bior3.7", "bior3.9", "bior4.4", "bior5.5", "bior6.8",
#' "rbio1.3", "rbio1.5", "rbio2.2", "rbio2.4", "rbio2.6", "rbio2.8", "rbio3.1", "rbio3.3",
#' "rbio3.5", "rbio3.7", "rbio3.9", "rbio4.4", "rbio5.5", "rbio6.8",
#' "la8", "la10", "la12", "la14", "la16", "la18", "la20",
#' "bl14", "bl18", "bl20",
#' "fk4", "fk6", "fk8", "fk14", "fk18", "fk22",
#' "b3spline")`
#'
#' @references
#' Percival, D. B. and A. T. Walden (2000) Wavelet Methods for Time Series Analysis, Cambridge
#' University Press.
scaling_filter <- function(wavelet) {
    .Call(`_fastWavelets_scaling_filter`, wavelet)
}

#' Compute Scaling Coefficients
#'
#' Compute the scaling coefficients.
#'
#' @param X A numeric vector
#' @param wavelet A character string indicating the scaling filter desired
#' @param j The decomposition level \[integer\]
#' @return Matrix of scaling coefficients
#' @references
#' Percival, D. B. and A. T. Walden (2000) Wavelet Methods for Time Series Analysis, Cambridge
#' University Press.
scaling_coefs <- function(X, wavelet, j) {
    .Call(`_fastWavelets_scaling_coefs`, X, wavelet, j)
}

#' Compute Wavelet Coefficients
#'
#' Compute the wavelet coefficients.
#'
#' @param X A numeric vector
#' @param wavelet A character string indicating the scaling filter desired
#' @param j The decomposition level \[integer\]
#' @return Matrix of wavelet coefficients
#' @references
#' Percival, D. B. and A. T. Walden (2000) Wavelet Methods for Time Series Analysis, Cambridge
#' University Press.
wavelet_coefs <- function(X, wavelet, j) {
    .Call(`_fastWavelets_wavelet_coefs`, X, wavelet, j)
}

