% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Fairness.R
\name{eval_stats_parity}
\alias{eval_stats_parity}
\title{Examine Statistical Parity of a Model}
\usage{
eval_stats_parity(
  data,
  outcome,
  group,
  probs,
  cutoff = 0.5,
  confint = TRUE,
  bootstraps = 2500,
  alpha = 0.05,
  digits = 2,
  message = TRUE
)
}
\arguments{
\item{data}{Data frame containing the outcome, predicted outcome, and
sensitive attribute}

\item{outcome}{Name of the outcome variable, it must be binary}

\item{group}{Name of the sensitive attribute}

\item{probs}{Name of the predicted outcome variable}

\item{cutoff}{Threshold for the predicted outcome, default is 0.5}

\item{confint}{Whether to compute 95\% confidence interval, default is TRUE}

\item{bootstraps}{Number of bootstrap samples, default is 2500}

\item{alpha}{The 1 - significance level for the confidence interval, default is 0.05}

\item{digits}{Number of digits to round the results to, default is 2}

\item{message}{Whether to print the results, default is TRUE}
}
\value{
A list containing the following elements:
\itemize{
\item PPR_Group1: Positive Prediction Rate for the first group
\item PPR_Group2: Positive Prediction Rate for the second group
\item PPR_Diff: Difference in Positive Prediction Rate
\item PPR_Ratio: The ratio in Positive Prediction Rate between the two groups.
If confidence intervals are computed (\code{confint = TRUE}):
\item PPR_Diff_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the difference in Positive Prediction
Rate
\item PPR_Ratio_CI: A vector of length 2 containing the lower and upper bounds
of the 95\% confidence interval for the ratio in Positive Prediction
Rate
}
}
\description{
This function assesses \emph{statistical parity} - also known as \emph{demographic parity} - in the predictions of a binary classifier across two groups defined by a sensitive attribute. Statistical parity compares the rate at which different groups receive a positive prediction, irrespective of the true outcome. It reports the Positive Prediction Rate (PPR) for each group, their differences, ratios, and bootstrap-based confidence regions.
}
\examples{
\donttest{
library(fairmetrics)
library(dplyr)
library(magrittr)
library(randomForest)
data("mimic_preprocessed")
set.seed(123)
train_data <- mimic_preprocessed \%>\%
  dplyr::filter(dplyr::row_number() <= 700)
# Fit a random forest model
rf_model <- randomForest::randomForest(factor(day_28_flg) ~ ., data = train_data, ntree = 1000)
# Test the model on the remaining data
test_data <- mimic_preprocessed \%>\%
  dplyr::mutate(gender = ifelse(gender_num == 1, "Male", "Female")) \%>\%
  dplyr::filter(dplyr::row_number() > 700)

test_data$pred <- predict(rf_model, newdata = test_data, type = "prob")[, 2]

# Fairness evaluation
# We will use sex as the sensitive attribute and day_28_flg as the outcome.
# We choose threshold = 0.41 so that the overall FPR is around 5\%.

# Evaluate Statistical Parity
eval_stats_parity(
  data = test_data,
  outcome = "day_28_flg",
  group = "gender",
  probs = "pred",
  cutoff = 0.41
)
}
}
\seealso{
\code{\link{eval_cond_stats_parity}}
}
