% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/RandomSkewers.R
\name{RandomSkewers}
\alias{RandomSkewers}
\alias{RandomSkewers.default}
\alias{RandomSkewers.list}
\title{Compare matrices via RandomSkewers}
\usage{
RandomSkewers(cov.x, cov.y, ...)

\method{RandomSkewers}{default}(cov.x, cov.y, num.vectors = 1000, ...)

\method{RandomSkewers}{list}(cov.x, cov.y = NULL, num.vectors = 1000,
  repeat.vector = NULL, parallel = FALSE, ...)
}
\arguments{
\item{cov.x}{Single covariance matrix or list of covariance matrices.
If single matrix is suplied, it is compared to cov.y.
If list is suplied and no cov.y is suplied, all matrices
are compared.
If cov.y is suplied, all matrices in list are compared to it.}

\item{cov.y}{First argument is compared to cov.y.
Optional if cov.x is a list.}

\item{...}{aditional arguments passed to other methods.}

\item{num.vectors}{Number of random vectors used in comparison.}

\item{repeat.vector}{Vector of repeatabilities for correlation correction.}

\item{parallel}{if TRUE computations are done in parallel. Some foreach backend must be registered, like doParallel or doMC.}
}
\value{
If cov.x and cov.y are passed, returns average value
of response vectors correlation ('correlation'), significance ('probability') and standard deviation
of response vectors correlation ('correlation_sd')

If cov.x and cov.y are passed, same as above, but for all matrices in cov.x.

If only a list is passed to cov.x, a matrix of RandomSkewers average
values and probabilities of all comparisons.
If repeat.vector is passed, comparison matrix is corrected above
diagonal and repeatabilities returned in diagonal.
}
\description{
Calculates covariance matrix correlation via random skewers
}
\examples{
c1 <- RandomMatrix(10)
c2 <- RandomMatrix(10)
c3 <- RandomMatrix(10)
RandomSkewers(c1, c2)

RandomSkewers(list(c1, c2, c3))

reps <- unlist(lapply(list(c1, c2, c3), MonteCarloRep, sample.size = 10,
                                        RandomSkewers, num.vectors = 100,
                                        iterations = 10))
RandomSkewers(list(c1, c2, c3), repeat.vector = reps)

c4 <- RandomMatrix(10)
RandomSkewers(list(c1, c2, c3), c4)

#Multiple threads can be used with some foreach backend library, like doMC or doParallel
#library(doParallel)
##Windows:
#cl <- makeCluster(2)
#registerDoParallel(cl)
##Mac and Linux:
#registerDoParallel(cores = 2)
#RandomSkewers(list(c1, c2, c3), parallel = TRUE)
}
\author{
Diogo Melo, Guilherme Garcia
}
\references{
Cheverud, J. M., and Marroig, G. (2007). Comparing covariance matrices:
Random skewers method compared to the common principal components model.
Genetics and Molecular Biology, 30, 461-469.
}
\seealso{
\code{\link{KrzCor}},\code{\link{MantelCor}}
}
\keyword{matrixcomparison}
\keyword{matrixcorrelation}
\keyword{randomskewers}

