% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autocor.R
\name{rw}
\alias{rw}
\title{Adds random walks with independent Gaussian steps to the parameterization of the time-varying reproduction number.}
\usage{
rw(time, gr, prior_scale = 0.2)
}
\arguments{
\item{time}{An optional name defining the random walk time periods for each
date and group. This must be a column name found in the \code{data} argument to \code{epim}.
If not specified, determined by the dates column implied by the \code{formula} argument to \code{epim}
is used.}

\item{gr}{Same as for \code{time}, except this defines the grouping to use for the random walks. A separate walk is defined
for each group. If not specified a common random walk is used for all groups.}

\item{prior_scale}{The steps of the walks are independent zero mean normal with an unknown scale hyperparameter. This scale is given
a half-normal prior. \code{prior_scale} sets the scale parameter of this hyperprior.}
}
\value{
A list to be parsed internally.
}
\description{
A call to \code{rw} can be used in the 'formula' argument of \code{epim}, allowing
random walks for the reproduction number. Does not evaluate arguments. Simply creates a
list with the information needed for the stan data to be parsed correctly.
}
\examples{

data("EuropeCovid")
args <- EuropeCovid
args$formula <- R(country, date) ~ 1 + rw(gr=country) + lockdown
}
