% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{EuropeCovid}
\alias{EuropeCovid}
\title{Covid-19 data for European countries}
\format{
A named list. The fields are:
\describe{
\item{data}{A data frame giving indicators of certain non-pharmaceutical interventions in each country, along with death data and populations.
The earliest date for each country in the dataframe is exactly 30 days before 10 cumulative deaths were observed in the country.}
\item{inf2death}{A numeric vector representing the time distribution from infection to death assumed in \insertCite{Flaxman2020;textual}{epidemia}.}
\item{si}{The serial interval of covid-19 assumed in \insertCite{Flaxman2020;textual}{epidemia}.}
}
}
\usage{
EuropeCovid
}
\description{
Contains a dataframe with recorded daily deaths from Covid-19 in 11 European countries up until 05/05/2020.
The dataframe includes variables representing different non-pharmaceutical interventions implemented by the
countries considered. The data matches that used in \insertCite{Flaxman2020;textual}{epidemia}. Also
includes empirical distributions for the serial interval and the time from infection to death.
}
\references{
\insertAllCited{}
}
\keyword{datasets}
